/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.IContentClassResourceBundle;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.CCDateWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.EditOptionDialog;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.IEditOptionDialogListener;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ImageAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldPropertiesDialog
extends DialogBox {
    private static final String TIP_MIN = "Enter positive integer from 1 to 99. Leave the field blank to use default (1) value.";
    private static final String TIP_MAX = "Enter positive integer from 1 to 99. Leave the field blank to use default (unlimited) value.";
    private static final String ERROR_STYLE = "WidgetValidationError";
    private static final IContentClassResourceBundle bundle = (IContentClassResourceBundle)GWT.create(IContentClassResourceBundle.class);
    private ContentClassFieldWidget widget;
    private MessageArea messageArea;
    private TextBox txtName;
    private TextBox txtDataType;
    private ListBox cbFieldType;
    private TextBox txtMin;
    private boolean minIsValid = true;
    private TextBox txtMax;
    private boolean maxIsValid = true;
    private CheckBox cbBatch;
    private CheckBox cbAutofillable;
    private ListBox listAutofillProvider;
    private FlexTable optionTable;
    private TextBox txtDisplayFormat;
    private boolean displayFormatIsValid = true;
    private Button btnSave;

    public FieldPropertiesDialog(ContentClassFieldWidget widget) {
        this.widget = widget;
        this.addStyleName("FieldPropertiesDialog");
        this.setModal(true);
        this.setText("Properties");
        this.setGlassEnabled(true);
        VerticalPanel rootPanel = new VerticalPanel();
        this.messageArea = new MessageArea();
        rootPanel.add((Widget)this.messageArea);
        this.messageArea.reset();
        Panel mainView = this.createMainView();
        Panel optionsView = this.createOptionsView();
        TabContainer tabContainer = new TabContainer();
        tabContainer.add((Widget)mainView, "Main");
        tabContainer.add((Widget)optionsView, "Options");
        tabContainer.selectTab(0);
        rootPanel.add((Widget)tabContainer);
        UIContentClassField.DataType dataType = widget.getField().getDataType();
        if (dataType == UIContentClassField.DataType.DATE || dataType == UIContentClassField.DataType.TIME) {
            tabContainer.getTabBar().setTabEnabled(1, false);
            this.cbFieldType.setEnabled(false);
            this.cbFieldType.setSelectedIndex(0);
        } else if (dataType == UIContentClassField.DataType.BOOLEAN) {
            this.cbFieldType.setEnabled(false);
            this.cbFieldType.setSelectedIndex(2);
        }
        Widget buttonPanel = this.createButtonPanel();
        rootPanel.add(buttonPanel);
        this.refresh();
        this.setWidget((Widget)rootPanel);
    }

    private ContentClassFieldWidget getContentClassFieldWidget() {
        return this.widget;
    }

    private void refresh() {
        if (this.widget == null) {
            return;
        }
        UIContentClassField field = this.widget.getField();
        if (field == null) {
            return;
        }
        boolean canSave = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Modify"});
        this.btnSave.setEnabled(canSave);
        this.txtName.setValue((Object)field.getDisplayName());
        this.txtDataType.setValue((Object)field.getDataType().name());
        String type = field.getFieldType().toString();
        int i = 1;
        while (i < this.cbFieldType.getItemCount()) {
            if (this.cbFieldType.getValue(i).equals(type)) {
                this.cbFieldType.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        if (field.isMultiValue()) {
            this.txtMin.setValue((Object)(field.getMin() == null ? "" : String.valueOf(field.getMin())));
            this.txtMax.setValue((Object)(field.getMax() == null ? "" : String.valueOf(field.getMax())));
        }
        if (this.cbBatch != null) {
            this.cbBatch.setValue(Boolean.valueOf(field.isIncludeInBatch()));
        }
        if (this.cbAutofillable != null) {
            this.cbAutofillable.setValue(Boolean.valueOf(field.isAutofillable()));
            String provider = field.getAutofillProvider();
            if (provider != null) {
                int i2 = 1;
                while (i2 < this.listAutofillProvider.getItemCount()) {
                    if (this.listAutofillProvider.getValue(i2).equals(provider)) {
                        this.listAutofillProvider.setSelectedIndex(i2);
                        break;
                    }
                    ++i2;
                }
            }
        }
        if (UIContentClassField.DataType.DATE == field.getDataType() || UIContentClassField.DataType.TIME == field.getDataType()) {
            this.txtDisplayFormat.setValue((Object)field.getDisplayFormat());
            this.cbFieldType.setEnabled(false);
        }
        if (field.canEditOptions()) {
            this.refreshOptionTable(field);
        }
    }

    private void refreshOptionTableHeader(UIContentClassField field) {
        final CheckBox mcb = new CheckBox();
        mcb.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean selected = mcb.getValue();
                int row = 1;
                while (row < FieldPropertiesDialog.this.optionTable.getRowCount()) {
                    CheckBox cb = (CheckBox)FieldPropertiesDialog.this.optionTable.getWidget(row, 0);
                    cb.setValue(Boolean.valueOf(selected));
                    ++row;
                }
            }
        });
        this.optionTable.setWidget(0, 0, (Widget)mcb);
        this.optionTable.setWidget(0, 1, (Widget)new Label("Value"));
        this.optionTable.setWidget(0, 2, (Widget)new Label("Display Name"));
        int i = 0;
        while (i <= 2) {
            this.optionTable.getCellFormatter().setStyleName(0, i, "portlet-tableHeader");
            ++i;
        }
        if (this.widget.getField().canAddOptions()) {
            ImageAnchor headerContextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
            HeaderContextMenuClickHandler headerContextMenuHandler = new HeaderContextMenuClickHandler();
            headerContextMenuAnchor.addClickHandler(headerContextMenuHandler);
            this.optionTable.setWidget(0, 3, (Widget)headerContextMenuAnchor);
            this.optionTable.getCellFormatter().setStyleName(0, 3, "portlet-table-text");
        }
    }

    private void refreshOptionTableData(UIContentClassField field) {
        List<KeyValuePair> list = field.getOptions();
        if (list == null) {
            return;
        }
        Set<String> excludedItems = field.getFilteredOptionKeys();
        int row = 1;
        for (KeyValuePair kvp : list) {
            CheckBox cb = new CheckBox();
            if (excludedItems == null || !excludedItems.contains(kvp.getValue())) {
                cb.setValue(Boolean.valueOf(true));
            }
            this.optionTable.setWidget(row, 0, (Widget)cb);
            this.optionTable.setWidget(row, 1, (Widget)new Label(kvp.getValue()));
            this.optionTable.setWidget(row, 2, (Widget)new Label(kvp.getKey()));
            int i = 0;
            while (i < 3) {
                this.optionTable.getCellFormatter().setStyleName(row, i, "portlet-table-text");
                ++i;
            }
            if (this.widget.getField().canAddOptions()) {
                ImageAnchor contextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
                ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(row, kvp.getValue(), kvp.getKey());
                contextMenuAnchor.setContextMenuClickHandler(contextMenuHandler);
                this.optionTable.setWidget(row, 3, (Widget)contextMenuAnchor);
                this.optionTable.getCellFormatter().setStyleName(row, 3, "portlet-table-text");
            }
            ++row;
        }
    }

    private void refreshOptionTable(UIContentClassField field) {
        this.optionTable.clear();
        this.refreshOptionTableHeader(field);
        this.refreshOptionTableData(field);
    }

    private Panel createMainView() {
        VerticalPanel panel = new VerticalPanel();
        panel.addStyleName("ContentClassEditView");
        if (this.widget == null || this.widget.getField() == null) {
            return panel;
        }
        UIContentClassField field = this.widget.getField();
        FlexTable table = new FlexTable();
        table.addStyleName("FormPanel");
        table.addStyleName("FormFieldTable");
        int row = 0;
        this.txtName = new TextBox();
        this.txtName.setEnabled(false);
        table.setWidget(row, 0, (Widget)new Label("Field Name"));
        table.setWidget(row, 1, (Widget)this.txtName);
        this.txtDataType = new TextBox();
        this.txtDataType.setEnabled(false);
        table.setWidget(++row, 0, (Widget)new Label("Data Type"));
        table.setWidget(row, 1, (Widget)this.txtDataType);
        ++row;
        this.cbFieldType = new ListBox();
        this.cbFieldType.setVisibleItemCount(1);
        this.cbFieldType.addItem("Text Box", "TEXT_BOX");
        this.cbFieldType.addItem("Text Area", "TEXT_AREA");
        this.cbFieldType.addItem("Drop Down", "DROP_DOWN");
        this.cbFieldType.addItem("Combo Box", "COMBO_BOX");
        table.setWidget(row, 0, (Widget)new Label("Field Type"));
        table.setWidget(row, 1, (Widget)this.cbFieldType);
        ++row;
        UIContentClassField uiField = this.widget.getField();
        if (uiField.isMultiValue()) {
            this.createMinField();
            table.setWidget(row, 0, (Widget)new Label("Min Occurrence"));
            table.setWidget(row, 1, (Widget)this.txtMin);
            this.createMaxField();
            table.setWidget(++row, 0, (Widget)new Label("Max Occurrence"));
            table.setWidget(row, 1, (Widget)this.txtMax);
            ++row;
        }
        if (!uiField.isMultiValue() || uiField.getMax() != null && uiField.getMax() == 1) {
            this.cbBatch = new CheckBox();
            table.setWidget(row, 0, (Widget)new Label("Include in Batch"));
            table.setWidget(row, 1, (Widget)this.cbBatch);
            ++row;
        }
        if (uiField.canHaveDefaultValue()) {
            List<KeyValuePair> providers;
            UIContentClass cc;
            this.cbAutofillable = new CheckBox();
            this.listAutofillProvider = new ListBox();
            this.listAutofillProvider.addItem("", null);
            if (this.widget != null && (cc = this.widget.getContentClass()) != null && (providers = cc.getAutofillProviders()) != null) {
                for (KeyValuePair kvp : providers) {
                    this.listAutofillProvider.addItem(kvp.getValue(), kvp.getKey());
                }
            }
            this.listAutofillProvider.setSelectedIndex(0);
            table.setWidget(row, 0, (Widget)new Label("Auto Fillable"));
            table.setWidget(row, 1, (Widget)this.cbAutofillable);
            table.setWidget(++row, 0, (Widget)new Label("Autofill Provider"));
            table.setWidget(row, 1, (Widget)this.listAutofillProvider);
            ++row;
        }
        if (UIContentClassField.DataType.DATE == field.getDataType()) {
            this.txtDisplayFormat = new TextBox();
            this.addDateChangeHandler(field);
            table.setWidget(row, 0, (Widget)new Label("Display Format"));
            table.setWidget(row, 1, (Widget)this.txtDisplayFormat);
            ++row;
        } else if (UIContentClassField.DataType.TIME == field.getDataType()) {
            this.txtDisplayFormat = new TextBox();
            this.addTimeChangeHandler(field);
            table.setWidget(row, 0, (Widget)new Label("Display Format"));
            table.setWidget(row, 1, (Widget)this.txtDisplayFormat);
            ++row;
        }
        panel.add((Widget)table);
        return panel;
    }

    private void createMinField() {
        this.txtMin = new TextBox();
        this.txtMin.setMaxLength(2);
        this.txtMin.setTitle(TIP_MIN);
        this.txtMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Integer iVal;
                Widget widget = (Widget)event.getSource();
                String value = FieldPropertiesDialog.trim((String)event.getValue());
                if (!(FieldPropertiesDialog.isEmpty(value) || (iVal = FieldPropertiesDialog.parseInt(value)) != null && iVal >= 1)) {
                    widget.addStyleName(FieldPropertiesDialog.ERROR_STYLE);
                    FieldPropertiesDialog.this.minIsValid = false;
                    return;
                }
                widget.removeStyleName(FieldPropertiesDialog.ERROR_STYLE);
                FieldPropertiesDialog.this.minIsValid = true;
            }
        });
    }

    private void createMaxField() {
        this.txtMax = new TextBox();
        this.txtMax.setMaxLength(2);
        this.txtMax.setTitle(TIP_MAX);
        this.txtMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Integer iVal;
                Widget widget = (Widget)event.getSource();
                String value = FieldPropertiesDialog.trim((String)event.getValue());
                if (!(FieldPropertiesDialog.isEmpty(value) || (iVal = FieldPropertiesDialog.parseInt(value)) != null && iVal >= 1)) {
                    widget.addStyleName(FieldPropertiesDialog.ERROR_STYLE);
                    FieldPropertiesDialog.this.maxIsValid = false;
                    return;
                }
                widget.removeStyleName(FieldPropertiesDialog.ERROR_STYLE);
                FieldPropertiesDialog.this.maxIsValid = true;
            }
        });
    }

    private void addDateChangeHandler(final UIContentClassField field) {
        this.txtDisplayFormat.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Widget widget = (Widget)event.getSource();
                String value = FieldPropertiesDialog.trim((String)event.getValue());
                DateTimeFormat df = null;
                if (!FieldPropertiesDialog.isEmpty(value)) {
                    try {
                        df = DateTimeFormat.getFormat((String)value);
                        df.format(new Date());
                    }
                    catch (Exception exception) {
                        widget.addStyleName(FieldPropertiesDialog.ERROR_STYLE);
                        FieldPropertiesDialog.this.displayFormatIsValid = false;
                        return;
                    }
                }
                widget.removeStyleName(FieldPropertiesDialog.ERROR_STYLE);
                FieldPropertiesDialog.this.displayFormatIsValid = true;
                field.setDisplayFormat(value);
                ContentClassFieldWidget ccWidget = FieldPropertiesDialog.this.getContentClassFieldWidget();
                CCDateWidget dateWidget = (CCDateWidget)ccWidget.getGwtWidget();
                DateConverter dc = (DateConverter)dateWidget.getDateConverter();
                dc.setOutputFormat(value);
                String displayValue = null;
                try {
                    Date date = dc.getDateForInputValue(field.getValue());
                    displayValue = dc.getDisplayValue(date);
                }
                catch (Exception exception) {}
                dateWidget.setTextValue(displayValue);
            }
        });
    }

    private void addTimeChangeHandler(final UIContentClassField field) {
        this.txtDisplayFormat.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Widget widget = (Widget)event.getSource();
                String value = FieldPropertiesDialog.trim((String)event.getValue());
                DateTimeFormat df = null;
                if (!FieldPropertiesDialog.isEmpty(value)) {
                    try {
                        df = DateTimeFormat.getFormat((String)value);
                        df.format(new Date());
                    }
                    catch (Exception exception) {
                        widget.addStyleName(FieldPropertiesDialog.ERROR_STYLE);
                        FieldPropertiesDialog.this.displayFormatIsValid = false;
                        return;
                    }
                }
                widget.removeStyleName(FieldPropertiesDialog.ERROR_STYLE);
                FieldPropertiesDialog.this.displayFormatIsValid = true;
                field.setDisplayFormat(value);
                field.setValue(null);
                ContentClassFieldWidget ccWidget = FieldPropertiesDialog.this.getContentClassFieldWidget();
                TextBox timeWidget = (TextBox)ccWidget.getGwtWidget();
                if (FieldPropertiesDialog.isEmpty(value)) {
                    timeWidget.setTitle("Please enter a time with format: HH:mm:ss");
                } else {
                    timeWidget.setTitle("Please enter a time with format: " + value);
                }
                timeWidget.setText("");
            }
        });
    }

    private Panel createOptionsView() {
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.addStyleName("Content");
        this.createOptionTable();
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.addStyleName("FormFieldTable");
        formPanel.add((Widget)this.optionTable);
        contentPanel.add((Widget)formPanel);
        return contentPanel;
    }

    private void createOptionTable() {
        this.optionTable = new FlexTable();
        this.optionTable.addStyleName("portletTable");
    }

    private Widget createButtonPanel() {
        this.btnSave = new Button("Save");
        this.btnSave.removeStyleName("gwt-Button");
        this.btnSave.addStyleName("ebBtn");
        this.btnSave.addStyleName("ebBtn_color_green");
        this.btnSave.addStyleName("save_button_icon");
        this.btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FieldPropertiesDialog.this.onSave();
            }
        });
        Button btnCancel = new Button("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FieldPropertiesDialog.this.onCancel();
            }
        });
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("ButtonPanel");
        buttonPanel.add((Widget)this.btnSave);
        buttonPanel.add((Widget)btnCancel);
        return buttonPanel;
    }

    private boolean validate() {
        HashSet<String> valueSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            CheckBox cfr_ignored_0 = (CheckBox)this.optionTable.getWidget(row, 0);
            Label lblValue = (Label)this.optionTable.getWidget(row, 1);
            Label lblDisplayName = (Label)this.optionTable.getWidget(row, 2);
            String value = lblValue.getText();
            String displayName = lblDisplayName.getText();
            if (valueSet.contains(value)) {
                this.messageArea.setErrorMessage("Option value is not unique: " + value);
                return false;
            }
            valueSet.add(value);
            if (nameSet.contains(displayName)) {
                this.messageArea.setErrorMessage("Option name is not unique: " + displayName);
                return false;
            }
            nameSet.add(displayName);
            ++row;
        }
        this.messageArea.reset();
        if (!this.minIsValid) {
            return false;
        }
        if (!this.maxIsValid) {
            return false;
        }
        return this.displayFormatIsValid;
    }

    private void onSave() {
        if (!this.validate()) {
            return;
        }
        this.setMainValues();
        this.setOptions();
        this.widget.refresh();
        this.hide();
    }

    private void onCancel() {
        this.hide();
    }

    private void setMainValues() {
        UIContentClassField uiField = this.widget.getField();
        int idx = this.cbFieldType.getSelectedIndex();
        String value = this.cbFieldType.getValue(idx);
        uiField.setFieldType(value);
        if (uiField.isMultiValue()) {
            uiField.setMin(FieldPropertiesDialog.parseInt(this.txtMin.getValue()));
            uiField.setMax(FieldPropertiesDialog.parseInt(this.txtMax.getValue()));
        }
        if (this.cbBatch != null) {
            uiField.setIncludeInBatch(this.cbBatch.getValue());
        }
        if (this.cbAutofillable != null) {
            uiField.setAutofillable(this.cbAutofillable.getValue());
            try {
                idx = this.listAutofillProvider.getSelectedIndex();
                value = this.listAutofillProvider.getValue(idx);
                uiField.setAutofillProvider(value);
            }
            catch (Exception exception) {
                uiField.setAutofillProvider(null);
            }
        }
        if (UIContentClassField.DataType.DATE == uiField.getDataType() || UIContentClassField.DataType.TIME == uiField.getDataType()) {
            uiField.setDisplayFormat(FieldPropertiesDialog.trim(this.txtDisplayFormat.getValue()));
        }
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() < 1;
    }

    private static Integer parseInt(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setOptions() {
        if (this.optionTable == null) {
            return;
        }
        ArrayList<KeyValuePair> options = new ArrayList<KeyValuePair>();
        HashSet<String> filteredKeys = new HashSet<String>();
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            CheckBox cb = (CheckBox)this.optionTable.getWidget(row, 0);
            Label lblValue = (Label)this.optionTable.getWidget(row, 1);
            Label lblDisplayName = (Label)this.optionTable.getWidget(row, 2);
            String value = lblValue.getText();
            String displayName = lblDisplayName.getText();
            options.add(new KeyValuePair(displayName, value));
            if (!cb.getValue().booleanValue()) {
                filteredKeys.add(value);
            }
            ++row;
        }
        this.widget.getField().setOptions(options);
        this.widget.getField().setFilteredOptionKeys(filteredKeys);
        String oldValue = this.widget.getField().getValue();
        if (oldValue != null && filteredKeys.contains(oldValue)) {
            this.widget.getField().setValue(null);
        }
    }

    private Image createContextMenuImage() {
        Image img = new Image(bundle.contextMenuImage());
        img.addStyleName("ContextMenuImage");
        return img;
    }

    private void deleteOption(int index) {
        if (index > 0) {
            this.optionTable.removeRow(index);
            this.updateIndices();
        }
    }

    private void updateIndices() {
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            ImageAnchor anchor = (ImageAnchor)this.optionTable.getWidget(row, 3);
            ContextMenuClickHandler handler = anchor.getContextMenuClickHandler();
            handler.setIndex(row);
            ++row;
        }
    }

    private void changeOption(int rowIndex, String value, String displayName) {
        if (rowIndex > 0 && rowIndex < this.optionTable.getRowCount()) {
            Label lblValue = (Label)this.optionTable.getWidget(rowIndex, 1);
            lblValue.setText(value.trim());
            Label lblName = (Label)this.optionTable.getWidget(rowIndex, 2);
            lblName.setText(displayName.trim());
        }
    }

    private String validateOptionBase(String newValue, String newDisplayName) {
        if (newValue == null || newValue.trim().length() < 1) {
            return "Value could not be empty";
        }
        if (newDisplayName == null || newDisplayName.trim().length() < 1) {
            return "Display name could not be empty";
        }
        UIContentClassField.DataType type = this.widget.getField().getDataType();
        if (type == UIContentClassField.DataType.BOOLEAN) {
            if (!newValue.equalsIgnoreCase("true") && !newValue.equalsIgnoreCase("false")) {
                return "Invalid boolean value. Valid values are 'true' or 'false'";
            }
        } else {
            if (type == UIContentClassField.DataType.INTEGER) {
                try {
                    Integer.parseInt(newValue);
                }
                catch (Exception exception) {
                    return "Invalid integer value";
                }
            }
            if (type == UIContentClassField.DataType.FLOAT) {
                try {
                    Double.parseDouble(newValue);
                }
                catch (Exception exception) {
                    return "Invalid float value";
                }
            }
        }
        return null;
    }

    private String validateOptionNew(String newValue, String newDisplayName) {
        String error = this.validateOptionBase(newValue, newDisplayName);
        if (error != null) {
            return error;
        }
        newValue = newValue.trim();
        newDisplayName = newDisplayName.trim();
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            CheckBox cfr_ignored_0 = (CheckBox)this.optionTable.getWidget(row, 0);
            Label lblValue = (Label)this.optionTable.getWidget(row, 1);
            Label lblDisplayName = (Label)this.optionTable.getWidget(row, 2);
            if (newValue.equals(lblValue.getText())) {
                return "Value is not unique";
            }
            if (newDisplayName.equals(lblDisplayName.getText())) {
                return "Display Name is not unique";
            }
            ++row;
        }
        return null;
    }

    private String validateOptionEdit(String newValue, String newDisplayName, int optionIndex, String oldValue, String oldDisplayName) {
        String error = this.validateOptionBase(newValue, newDisplayName);
        if (error != null) {
            return error;
        }
        newValue = newValue.trim();
        newDisplayName = newDisplayName.trim();
        boolean skipOldValueCheck = newValue.equals(oldValue);
        boolean skipOldDisplayNameCheck = newDisplayName.equals(oldDisplayName);
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            CheckBox cfr_ignored_0 = (CheckBox)this.optionTable.getWidget(row, 0);
            Label lblValue = (Label)this.optionTable.getWidget(row, 1);
            Label lblDisplayName = (Label)this.optionTable.getWidget(row, 2);
            if (newValue.equals(lblValue.getText()) && (!skipOldValueCheck || row != optionIndex)) {
                return "Value is not unique";
            }
            if (newDisplayName.equals(lblDisplayName.getText()) && (!skipOldDisplayNameCheck || row != optionIndex)) {
                return "Display Name is not unique";
            }
            ++row;
        }
        return null;
    }

    private void addOption(String value, String displayName) {
        CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(true));
        ImageAnchor contextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
        ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(this.optionTable.getRowCount(), value.trim(), displayName.trim());
        contextMenuAnchor.setContextMenuClickHandler(contextMenuHandler);
        int row = this.optionTable.getRowCount();
        this.optionTable.setWidget(row, 0, (Widget)cb);
        this.optionTable.setWidget(row, 1, (Widget)new Label(value));
        this.optionTable.setWidget(row, 2, (Widget)new Label(displayName));
        this.optionTable.setWidget(row, 3, (Widget)contextMenuAnchor);
        int i = 0;
        while (i <= 3) {
            this.optionTable.getCellFormatter().setStyleName(row, i, "portlet-table-text");
            ++i;
        }
    }

    public class ContextMenuClickHandler
    implements ClickHandler,
    IEditOptionDialogListener {
        private String optionValue;
        private String optionDisplayName;
        private int optionIndex = -1;
        private int lastCommand;
        private static final int CMD_EDIT = 1;

        ContextMenuClickHandler(int index, String value, String displayName) {
            this.optionIndex = index;
            this.optionValue = value;
            this.optionDisplayName = displayName;
        }

        public void setIndex(int index) {
            this.optionIndex = index;
        }

        public void onClick(ClickEvent event) {
            final PopupPanel menuPanel = new PopupPanel(true);
            menuPanel.addStyleName("ContentClassPopupPanel");
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            menuPanel.setPopupPosition(x, y);
            MenuBar menu = new MenuBar(true);
            menu.addItem("Edit...", (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    menuPanel.hide();
                    ContextMenuClickHandler.this.lastCommand = 1;
                    EditOptionDialog dialog = new EditOptionDialog(ContextMenuClickHandler.this);
                    dialog.refresh(ContextMenuClickHandler.this.optionValue, ContextMenuClickHandler.this.optionDisplayName);
                    dialog.center();
                }
            });
            menu.addItem("Delete", (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    FieldPropertiesDialog.this.deleteOption(ContextMenuClickHandler.this.optionIndex);
                    menuPanel.hide();
                }
            });
            menuPanel.add((Widget)menu);
            menuPanel.show();
        }

        @Override
        public String onSave(String newValue, String newDisplayName) {
            switch (this.lastCommand) {
                case 1: {
                    String validationError = FieldPropertiesDialog.this.validateOptionEdit(newValue, newDisplayName, this.optionIndex, this.optionValue, this.optionDisplayName);
                    if (validationError != null) {
                        return validationError;
                    }
                    this.optionValue = newValue.trim();
                    this.optionDisplayName = newDisplayName.trim();
                    FieldPropertiesDialog.this.changeOption(this.optionIndex, newValue, newDisplayName);
                    return null;
                }
            }
            return null;
        }
    }

    private class HeaderContextMenuClickHandler
    implements ClickHandler,
    IEditOptionDialogListener {
        HeaderContextMenuClickHandler() {
        }

        public void onClick(ClickEvent event) {
            final PopupPanel menuPanel = new PopupPanel(true);
            menuPanel.addStyleName("ContentClassPopupPanel");
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            menuPanel.setPopupPosition(x, y);
            MenuBar menu = new MenuBar(true);
            menu.addItem("Add New...", (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    menuPanel.hide();
                    EditOptionDialog dialog = new EditOptionDialog(HeaderContextMenuClickHandler.this);
                    dialog.refresh();
                    dialog.center();
                }
            });
            menuPanel.add((Widget)menu);
            menuPanel.show();
        }

        @Override
        public String onSave(String newValue, String newDisplayName) {
            String validationError = FieldPropertiesDialog.this.validateOptionNew(newValue, newDisplayName);
            if (validationError != null) {
                return validationError;
            }
            FieldPropertiesDialog.this.addOption(newValue, newDisplayName);
            return null;
        }
    }
}

