/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PartnerFieldPropertiesDialog
extends DialogBox {
    private ContentClassFieldWidget widget;
    private FlexTable optionTable;

    public PartnerFieldPropertiesDialog(ContentClassFieldWidget widget) {
        this.widget = widget;
        this.addStyleName("FieldPropertiesDialog");
        this.setModal(true);
        this.setText("Options");
        this.setGlassEnabled(true);
        VerticalPanel rootPanel = new VerticalPanel();
        Panel optionsView = this.createOptionsView();
        rootPanel.add((Widget)optionsView);
        Widget buttonPanel = this.createButtonPanel();
        rootPanel.add(buttonPanel);
        this.refresh();
        this.setWidget((Widget)rootPanel);
    }

    private Panel createOptionsView() {
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.addStyleName("Content");
        this.createOptionTable();
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.addStyleName("FormFieldTable");
        formPanel.add((Widget)this.optionTable);
        contentPanel.add((Widget)formPanel);
        return contentPanel;
    }

    private void createOptionTable() {
        this.optionTable = new FlexTable();
        this.optionTable.addStyleName("portletTable");
    }

    private Widget createButtonPanel() {
        Button btnSave = new Button("Save");
        btnSave.removeStyleName("gwt-Button");
        btnSave.addStyleName("ebBtn");
        btnSave.addStyleName("ebBtn_color_green");
        btnSave.addStyleName("save_button_icon");
        btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PartnerFieldPropertiesDialog.this.onSave();
            }
        });
        Button btnCancel = new Button("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PartnerFieldPropertiesDialog.this.onCancel();
            }
        });
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("ButtonPanel");
        buttonPanel.add((Widget)btnSave);
        buttonPanel.add((Widget)btnCancel);
        return buttonPanel;
    }

    private void onSave() {
        this.setOptions();
        this.hide();
    }

    private void onCancel() {
        this.hide();
    }

    private void setOptions() {
        HashSet<String> filteredKeys = new HashSet<String>();
        int row = 1;
        while (row < this.optionTable.getRowCount()) {
            CheckBox cb = (CheckBox)this.optionTable.getWidget(row, 0);
            Label lblValue = (Label)this.optionTable.getWidget(row, 1);
            String value = lblValue.getText();
            if (!cb.getValue().booleanValue()) {
                filteredKeys.add(value);
            }
            ++row;
        }
        this.widget.getField().setFilteredOptionKeys(filteredKeys);
        this.widget.refresh();
        String oldValue = this.widget.getField().getValue();
        if (oldValue != null && filteredKeys.contains(oldValue)) {
            this.widget.getField().setValue(null);
        }
    }

    private void refresh() {
        if (this.widget == null) {
            return;
        }
        UIContentClassField field = this.widget.getField();
        if (field == null) {
            return;
        }
        this.optionTable.clear();
        final CheckBox mcb = new CheckBox();
        mcb.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean selected = mcb.getValue();
                int row = 1;
                while (row < PartnerFieldPropertiesDialog.this.optionTable.getRowCount()) {
                    CheckBox cb = (CheckBox)PartnerFieldPropertiesDialog.this.optionTable.getWidget(row, 0);
                    cb.setValue(Boolean.valueOf(selected));
                    ++row;
                }
            }
        });
        this.optionTable.setWidget(0, 0, (Widget)mcb);
        this.optionTable.setWidget(0, 1, (Widget)new Label("Value"));
        this.optionTable.setWidget(0, 2, (Widget)new Label("Display Name"));
        int i = 0;
        while (i <= 2) {
            this.optionTable.getCellFormatter().setStyleName(0, i, "portlet-tableHeader");
            ++i;
        }
        List<KeyValuePair> list = field.getOptions();
        Set<String> excludedItems = field.getFilteredOptionKeys();
        int row = 1;
        for (KeyValuePair kvp : list) {
            CheckBox cb = new CheckBox();
            if (excludedItems == null || !excludedItems.contains(kvp.getValue())) {
                cb.setValue(Boolean.valueOf(true));
            }
            this.optionTable.setWidget(row, 0, (Widget)cb);
            this.optionTable.setWidget(row, 1, (Widget)new Label(kvp.getValue()));
            this.optionTable.setWidget(row, 2, (Widget)new Label(kvp.getKey()));
            int i2 = 0;
            while (i2 <= 2) {
                this.optionTable.getCellFormatter().setStyleName(row, i2, "portlet-table-text");
                ++i2;
            }
            ++row;
        }
    }
}

