/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.model;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetMessages;
import java.util.ArrayList;
import java.util.List;

public class ContentClassValidator {
    public static final byte VALIDATOR_GLOBAL_CC = 0;
    public static final byte VALIDATOR_PARTNER_CC = 1;
    private static DataTypeWidgetMessages messages = (DataTypeWidgetMessages)GWT.create(DataTypeWidgetMessages.class);
    private List<ValidationError> errors;
    private int maxErrors;
    private UIContentClassAsset currentAsset;
    private byte validatorType = 0;

    public ContentClassValidator(byte validatorType) {
        this.validatorType = validatorType;
        this.errors = new ArrayList<ValidationError>();
        this.maxErrors = 10;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public void validate(UIContentClass cc) {
        this.errors.clear();
        this.currentAsset = null;
        if (cc == null) {
            return;
        }
        this.validateAsset(cc.getRootAsset());
    }

    public void validate(UIContentClassPartner ccp) {
        this.errors.clear();
        this.currentAsset = null;
        if (ccp == null) {
            return;
        }
        this.validateAsset(ccp.getRootAsset());
    }

    private void validateAsset(UIContentClassAsset asset) {
        if (asset == null) {
            return;
        }
        if (this.errors.size() >= this.maxErrors) {
            return;
        }
        this.currentAsset = asset;
        if (this.validatorType == 0) {
            this.validateAssetCardinality(asset);
        }
        this.validateFields(asset.getFields());
        List<UIContentClassAsset> childAssets = asset.getAssets();
        if (childAssets == null) {
            return;
        }
        for (UIContentClassAsset childAsset : childAssets) {
            this.validateAsset(childAsset);
        }
    }

    private void validateAssetCardinality(UIContentClassAsset asset) {
        ValidationError error;
        boolean parseError = false;
        if (asset.strMin != null) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Invalid Min Occurrence value. Enter an integer value greater than or equal to 0.");
            this.errors.add(error);
            parseError = true;
        }
        if (asset.strMax != null) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Invalid Max Occurrence value. Enter an integer value greater than or equal to 1.");
            this.errors.add(error);
            parseError = true;
        }
        if (asset.strBatchMin != null) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Invalid Min Batch Occurrence value. Enter an integer value greater than or equal to 0.");
            this.errors.add(error);
            parseError = true;
        }
        if (asset.strBatchMax != null) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Invalid Max Batch Occurrence value. Enter an integer value greater than or equal to 0.");
            this.errors.add(error);
            parseError = true;
        }
        if (parseError) {
            return;
        }
        if (asset.getMax() > asset.getMaxAllowed()) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Occurrence value could not be greater than " + asset.getMaxAllowed());
            this.errors.add(error);
        }
        if (asset.getMin() > asset.getMax()) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Occurrence value could not be less than Min Occurrence");
            this.errors.add(error);
        }
        if (asset.getMin() < 0) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Min Occurrence value should be between 0 and " + asset.getMaxAllowed());
            this.errors.add(error);
        }
        if (asset.getMax() < 0) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Occurrence value should be between 0 and " + asset.getMaxAllowed());
            this.errors.add(error);
        }
        if (asset.getBatchMax() > asset.getMaxAllowed()) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Batch Occurrence value could not be greater than " + asset.getMaxAllowed());
            this.errors.add(error);
        }
        if (asset.getBatchMin() > asset.getBatchMax()) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Batch Occurrence value could not be less than Min Occurrence");
            this.errors.add(error);
        }
        if (asset.getBatchMin() < 0) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Min Batch Occurrence value should be between 0 and " + asset.getMaxAllowed());
            this.errors.add(error);
        }
        if (asset.getBatchMax() < 0) {
            error = new ValidationError(this.currentAsset, null);
            error.setMessage("Max Batch Occurrence value should be between 0 and " + asset.getMaxAllowed());
            this.errors.add(error);
        }
    }

    private void validateFields(List<UIContentClassField> fields) {
        if (fields == null) {
            return;
        }
        for (UIContentClassField field : fields) {
            if (this.errors.size() >= this.maxErrors) {
                return;
            }
            if (field instanceof UIContentClassFieldGroup) {
                this.validateFields(((UIContentClassFieldGroup)field).getFields());
                continue;
            }
            this.validateField(field);
        }
    }

    private void validateField(UIContentClassField field) {
        if (field == null) {
            return;
        }
        switch (field.getDataType()) {
            case DATE: {
                if (field.isValid()) break;
                ValidationError error = new ValidationError(this.currentAsset, field);
                String displayFormatPattern = field.getDisplayFormat();
                if (displayFormatPattern == null || displayFormatPattern.trim().length() == 0) {
                    displayFormatPattern = messages.dateWidgetFormat();
                }
                error.setMessage(messages.dateWidgetErrorToolTip(displayFormatPattern));
                this.errors.add(error);
                break;
            }
            case TIME: {
                if (field.isValid()) break;
                ValidationError error = new ValidationError(this.currentAsset, field);
                if (field.isTimeCodeType()) {
                    error.setMessage(messages.timeCodeWidgetErrorToolTip());
                } else {
                    String displayFormatPattern = field.getDisplayFormat();
                    if (displayFormatPattern == null || displayFormatPattern.trim().length() == 0) {
                        displayFormatPattern = messages.timeWidgetFormat();
                    }
                    error.setMessage(messages.timeWidgetErrorToolTip(displayFormatPattern));
                }
                this.errors.add(error);
                break;
            }
            case INTEGER: {
                if (field.isValid()) break;
                ValidationError error = new ValidationError(this.currentAsset, field);
                error.setMessage(messages.integerWidgetErrorToolTip());
                this.errors.add(error);
                break;
            }
            case FLOAT: {
                if (field.isValid()) break;
                ValidationError error = new ValidationError(this.currentAsset, field);
                error.setMessage(messages.floatWidgetErrorToolTip());
                this.errors.add(error);
                break;
            }
        }
    }

    public static boolean isTimeCodeValid(String value) {
        int ss;
        block9: {
            int mm;
            block8: {
                if (value.length() != 11) {
                    return false;
                }
                if (value.charAt(2) != ':') {
                    return false;
                }
                if (value.charAt(5) != ':') {
                    return false;
                }
                if (value.charAt(8) != ':') {
                    return false;
                }
                try {
                    int hh = Integer.parseInt(value.substring(0, 2));
                    mm = Integer.parseInt(value.substring(3, 5));
                    ss = Integer.parseInt(value.substring(6, 8));
                    Integer.parseInt(value.substring(9));
                    if (hh <= 23) break block8;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (mm <= 60) break block9;
            return false;
        }
        return ss <= 60;
    }
}

