/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import java.util.ArrayList;
import java.util.List;

public class UIContentClassAsset
implements IsSerializable {
    private String path;
    private String displayName;
    private List<UIContentClassField> fields;
    private List<UIContentClassAsset> assets;
    public int min = 1;
    public int max = 1;
    public String strMin;
    public String strMax;
    private int maxAllowed;
    public int batchMin = 0;
    public int batchMax = 0;
    public String strBatchMin;
    public String strBatchMax;
    private boolean disabled;
    private boolean requiresFile;
    private boolean hideFileView;

    public UIContentClassAsset() {
    }

    public UIContentClassAsset(String path) {
        this.path = path;
        if ("PACKAGE".equals(path) || "PACKAGE/TITLE".equals(path)) {
            this.min = 1;
            this.batchMin = 1;
            this.batchMax = 1;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPath() {
        return this.path;
    }

    public List<UIContentClassField> getFields() {
        return this.fields;
    }

    public void setFields(List<UIContentClassField> fields) {
        this.fields = fields;
    }

    public List<UIContentClassAsset> getAssets() {
        return this.assets;
    }

    public boolean hasAssets() {
        return this.assets != null && !this.assets.isEmpty();
    }

    public void addAsset(UIContentClassAsset asset) {
        if (this.assets == null) {
            this.assets = new ArrayList<UIContentClassAsset>();
        }
        this.assets.add(asset);
    }

    public int getMin() {
        return this.min;
    }

    public String getMinForUI() {
        return this.strMin != null ? this.strMin : String.valueOf(this.min);
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public String getMaxForUI() {
        return this.strMax != null ? this.strMax : String.valueOf(this.max);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMaxAllowed() {
        return this.maxAllowed;
    }

    public void setMaxAllowed(int maxAllowed) {
        this.maxAllowed = maxAllowed;
    }

    public int getBatchMin() {
        return this.batchMin;
    }

    public String getBatchMinForUI() {
        return this.strBatchMin != null ? this.strBatchMin : String.valueOf(this.batchMin);
    }

    public void setBatchMin(int batchMin) {
        this.batchMin = batchMin;
    }

    public int getBatchMax() {
        return this.batchMax;
    }

    public String getBatchMaxForUI() {
        return this.strBatchMax != null ? this.strBatchMax : String.valueOf(this.batchMax);
    }

    public void setBatchMax(int batchMax) {
        this.batchMax = batchMax;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.assets != null) {
            for (UIContentClassAsset cAsset : this.assets) {
                cAsset.setDisabled(disabled);
            }
        }
    }

    public boolean canHaveFile() {
        return true;
    }

    public boolean canBatchEdit() {
        return "PACKAGE".equals(this.path) || "PACKAGE/TITLE".equals(this.path);
    }

    public boolean isRequiresFile() {
        if (this.canHaveFile()) {
            return this.requiresFile;
        }
        return false;
    }

    public void setRequiresFile(boolean requiresFile) {
        this.requiresFile = requiresFile;
    }

    public boolean isHideFileView() {
        if (this.canHaveFile()) {
            return this.hideFileView;
        }
        return true;
    }

    public void setHideFileView(boolean hideFileView) {
        this.hideFileView = hideFileView;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isRoot() {
        if (this.path == null) {
            return true;
        }
        return !this.path.contains("/");
    }
}

