/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.model;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ContentClassValidator;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UIContentClassField
implements IsSerializable {
    private static final KeyValuePair.KeyComparator keyComparator = new KeyValuePair.KeyComparator();
    private static final DateTimeFormat dateFormat = UIContentClassField.getFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormat timeFormat = UIContentClassField.getFormat("HH:mm:ss");
    private String path;
    private String displayName;
    private String displayFormat;
    private DataType dataType = DataType.STRING;
    private FieldType fieldType = FieldType.TEXT_BOX;
    private boolean readOnly;
    private Integer min;
    private Integer max;
    private boolean multiValue;
    private boolean includeInBatch;
    private boolean isAutofillable;
    private String autofillProvider;
    private boolean isAttribute;
    private boolean isRequired;
    private List<KeyValuePair> options;
    private String value;
    private boolean isLocked;
    private boolean disabled = true;
    private boolean hideInUI;
    private boolean canAddOptions = false;
    private String parentValue;
    private boolean isParentLocked;
    private Set<String> filteredOptionKeys;

    public UIContentClassField() {
    }

    public UIContentClassField(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public List<KeyValuePair> getOptions() {
        return this.options;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public boolean canEditOptions() {
        return this.dataType != DataType.DATE && this.dataType != DataType.TIME;
    }

    public void setOptions(List<KeyValuePair> suggestedValues) {
        this.options = suggestedValues;
        if (this.options != null) {
            Collections.sort(this.options, keyComparator);
        }
    }

    public Set<String> getFilteredOptionKeys() {
        return this.filteredOptionKeys;
    }

    public void setFilteredOptionKeys(Collection<String> keys) {
        if (keys != null && !keys.isEmpty()) {
            if (this.filteredOptionKeys == null) {
                this.filteredOptionKeys = new HashSet<String>();
            }
            this.filteredOptionKeys.clear();
            this.filteredOptionKeys.addAll(keys);
        } else {
            this.filteredOptionKeys = null;
        }
    }

    public boolean hasFilteredOptions() {
        return this.filteredOptionKeys != null && !this.filteredOptionKeys.isEmpty();
    }

    public void addFilteredOptionKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (this.filteredOptionKeys == null) {
            this.filteredOptionKeys = new HashSet<String>();
        }
        this.filteredOptionKeys.addAll(keys);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setDataType(String strDataType) {
        try {
            this.dataType = DataType.valueOf(strDataType.toUpperCase());
        }
        catch (Exception exception) {
            this.dataType = DataType.STRING;
        }
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public void setFieldType(String strFieldType) {
        try {
            this.fieldType = FieldType.valueOf(strFieldType.toUpperCase());
        }
        catch (Exception exception) {
            this.fieldType = FieldType.TEXT_BOX;
        }
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    public String getParentValue() {
        return this.parentValue;
    }

    public void setParentValue(String parentValue) {
        this.parentValue = parentValue;
    }

    public boolean isParentLocked() {
        return this.isParentLocked;
    }

    public void setParentLocked(boolean isParentLocked) {
        this.isParentLocked = isParentLocked;
    }

    public boolean isEmpty() {
        return this.value == null || this.value.trim().length() < 1;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean hasNonDefaultValues() {
        if (!this.isEmpty()) {
            return true;
        }
        if (this.getMin() != null || this.getMax() != null) {
            return true;
        }
        if (this.isLocked()) {
            return true;
        }
        if (this.isAutofillable()) {
            return true;
        }
        if (this.autofillProvider != null && this.autofillProvider.trim().length() > 0) {
            return true;
        }
        if (this.displayFormat != null && this.displayFormat.trim().length() > 0) {
            return true;
        }
        if (this.isIncludeInBatch()) {
            return true;
        }
        if (this.options != null && !this.options.isEmpty()) {
            return true;
        }
        return this.hasFilteredOptions();
    }

    public boolean hasNonDefaultPartnerValues() {
        if (!this.isEmpty()) {
            return true;
        }
        if (this.isLocked()) {
            return true;
        }
        return this.hasFilteredOptions();
    }

    public boolean isValid() {
        switch (this.dataType) {
            case STRING: {
                return true;
            }
            case INTEGER: {
                if (this.isEmpty()) {
                    return true;
                }
                try {
                    Integer.parseInt(this.value.trim());
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            case FLOAT: {
                if (this.isEmpty()) {
                    return true;
                }
                try {
                    Double.parseDouble(this.value.trim());
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            case DATE: {
                if (this.isEmpty()) {
                    return true;
                }
                try {
                    dateFormat.parse(this.value.trim());
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            case TIME: {
                if (this.isEmpty()) {
                    return true;
                }
                if (this.isTimeCodeType()) {
                    return ContentClassValidator.isTimeCodeValid(this.value.trim());
                }
                try {
                    if (this.displayFormat == null || this.displayFormat.isEmpty()) {
                        timeFormat.parse(this.value.trim());
                    } else {
                        DateTimeFormat customFormat = UIContentClassField.getFormat(this.displayFormat);
                        customFormat.parse(this.value.trim());
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return true;
    }

    private static DateTimeFormat getFormat(String format) {
        if (GWT.isClient()) {
            return DateTimeFormat.getFormat((String)format);
        }
        return null;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public void setDisabled(boolean isHidden) {
        this.disabled = isHidden;
    }

    public boolean hideInUI() {
        return this.hideInUI;
    }

    public void setHideInUI(boolean hide) {
        this.hideInUI = hide;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public boolean isIncludeInBatch() {
        return this.includeInBatch;
    }

    public void setIncludeInBatch(boolean includeInBatch) {
        this.includeInBatch = includeInBatch;
    }

    public boolean isAutofillable() {
        return this.isAutofillable;
    }

    public void setAutofillable(boolean isAutofillable) {
        this.isAutofillable = isAutofillable;
    }

    public String getAutofillProvider() {
        return this.autofillProvider;
    }

    public void setAutofillProvider(String autofillProvider) {
        this.autofillProvider = autofillProvider;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public boolean canHaveDefaultValue() {
        return !this.isReadOnly();
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean canAddOptions() {
        return this.canAddOptions;
    }

    public void setCanAddOptions(boolean canAddOptions) {
        this.canAddOptions = canAddOptions;
    }

    public boolean isTimeCodeType() {
        return this.path.endsWith("/TimeCodeOne") || this.path.endsWith("/TimeCodeTwo") || this.path.endsWith("/TimeCodeThree") || this.path.endsWith("/TimeCodeFour");
    }

    public static enum DataType implements IsSerializable
    {
        STRING,
        BOOLEAN,
        INTEGER,
        FLOAT,
        DATE,
        TIME;

    }

    public static enum FieldType implements IsSerializable
    {
        TEXT_BOX,
        TEXT_AREA,
        DROP_DOWN,
        COMBO_BOX;

    }
}

