/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.IContentClassResourceBundle;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.ComplexFieldPropertiesDialog;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ImageAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import java.util.List;

public class ContentClassComplexFieldWidget
extends Composite {
    private static final IContentClassResourceBundle bundle = (IContentClassResourceBundle)GWT.create(IContentClassResourceBundle.class);
    private UIContentClassFieldGroup group;
    private SimplePanel rootPanel;
    private Image imgDisabled = new Image(bundle.getDisabledImage());
    private Image imgEnabled = new Image(bundle.getEnabledImage());
    private HorizontalPanel hp;
    private static PopupPanel menuPanel;

    public ContentClassComplexFieldWidget(UIContentClassFieldGroup group, boolean isEditable, UIContentClass cc) {
        this.group = group;
        this.rootPanel = new SimplePanel();
        this.initWidget((Widget)this.rootPanel);
        this.addStyleName("ContentClassComplexFieldWidget");
        if (group == null) {
            this.rootPanel.setWidget((Widget)new Label("No Data"));
            return;
        }
        List<UIContentClassField> fields = group.getFields();
        if (fields == null || fields.isEmpty()) {
            this.rootPanel.setWidget((Widget)new Label("No Data"));
            return;
        }
        VerticalPanel vp = new VerticalPanel();
        menuPanel = new PopupPanel(true);
        menuPanel.addStyleName("ContentClassPopupPanel");
        FlexTable table = new FlexTable();
        table.addStyleName("FormFieldTable");
        int row = 0;
        for (UIContentClassField field : fields) {
            if (field instanceof UIContentClassFieldGroup) continue;
            HTML label = new HTML();
            table.setWidget(row, 0, (Widget)label);
            table.getCellFormatter().setAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
            ContentClassFieldWidget widget = new ContentClassFieldWidget(ContentClassFieldWidget.Type.ContentClass, field, isEditable, cc, label);
            table.setWidget(row, 1, (Widget)widget);
            if (field.isRequired()) {
                widget.setRequired(true);
            } else {
                widget.setRequired(false);
            }
            ++row;
        }
        vp.add((Widget)table);
        for (UIContentClassField field : fields) {
            if (!(field instanceof UIContentClassFieldGroup)) continue;
            UIContentClassFieldGroup childGroup = (UIContentClassFieldGroup)field;
            ContentClassComplexFieldWidget groupWidget = new ContentClassComplexFieldWidget(childGroup, isEditable, cc);
            vp.add((Widget)groupWidget);
        }
        RoundedDisclosureContainer rdc = new RoundedDisclosureContainer(group.getDisplayName());
        rdc.setContent((Widget)vp);
        if (group.getPath() != null) {
            this.hp = new HorizontalPanel();
            this.hp.addStyleName("Content");
            this.hp.add((Widget)rdc);
            ImageAnchor contextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
            ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(this);
            contextMenuAnchor.addClickHandler(contextMenuHandler);
            this.hp.add((Widget)contextMenuAnchor);
            this.hp.add((Widget)this.imgDisabled);
            if (group.isDisabled()) {
                this.disable();
                this.hp.add((Widget)this.imgDisabled);
            } else {
                this.enable();
                this.hp.add((Widget)this.imgEnabled);
            }
            this.rootPanel.setWidget((Widget)this.hp);
        } else {
            this.rootPanel.setWidget((Widget)vp);
        }
    }

    public void disable() {
        this.group.setDisabled(true);
        this.hp.remove((Widget)this.imgEnabled);
        this.hp.add((Widget)this.imgDisabled);
    }

    public void enable() {
        this.group.setDisabled(false);
        this.hp.remove((Widget)this.imgDisabled);
        this.hp.add((Widget)this.imgEnabled);
    }

    public UIContentClassFieldGroup getGroup() {
        return this.group;
    }

    private Image createContextMenuImage() {
        Image img = new Image(bundle.contextMenuImage());
        img.addStyleName("ContextMenuImage");
        return img;
    }

    protected void onUnload() {
        menuPanel.hide();
        super.onUnload();
    }

    private static class ContextMenuClickHandler
    implements ClickHandler {
        private ContentClassComplexFieldWidget widget;

        public ContextMenuClickHandler(ContentClassComplexFieldWidget widget) {
            this.widget = widget;
        }

        public void onClick(ClickEvent event) {
            menuPanel.clear();
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            menuPanel.setPopupPosition(x, y);
            MenuBar menu = new MenuBar(true);
            if (this.widget.getGroup().isDisabled()) {
                menu.addItem("Enable", (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        widget.enable();
                        menuPanel.hide();
                    }
                });
            } else {
                menu.addItem("Disable", (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        widget.disable();
                        menuPanel.hide();
                    }
                });
            }
            if (this.widget.getGroup().isMultiValue()) {
                menu.addItem("Properties...", (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        menuPanel.hide();
                        ComplexFieldPropertiesDialog dialog = new ComplexFieldPropertiesDialog(widget);
                        dialog.center();
                    }
                });
            }
            menuPanel.add((Widget)menu);
            menuPanel.show();
        }
    }
}

