/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.IContentClassResourceBundle;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.FieldPropertiesDialog;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.PartnerFieldPropertiesDialog;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassWidgetFactory;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ImageAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;

public class ContentClassFieldWidget
extends Composite {
    private static final IContentClassResourceBundle bundle = (IContentClassResourceBundle)GWT.create(IContentClassResourceBundle.class);
    private SimplePanel rootPanel;
    private HorizontalPanel hp;
    private Image lockImage;
    private Image disabledImage;
    private Image hideInUIOnlyImage;
    private Image autofillImage;
    private Image enabledImage;
    private HTML label;
    private Widget simpleWidget;
    private Type type;
    private UIContentClassField field;
    private UIContentClass contentClass;
    private UIContentClassField.FieldType prevFieldType;
    private static PopupPanel menuPanel;

    public ContentClassFieldWidget(Type type, UIContentClassField field, boolean isEditable, UIContentClass cc, HTML label) {
        ImageAnchor contextMenuAnchor;
        this.type = type;
        this.field = field;
        this.contentClass = cc;
        this.prevFieldType = field.getFieldType();
        this.label = label;
        this.rootPanel = new SimplePanel();
        this.initWidget((Widget)this.rootPanel);
        boolean widgetIsEditable = isEditable;
        if (isEditable) {
            widgetIsEditable = field.canHaveDefaultValue();
        }
        this.simpleWidget = ContentClassWidgetFactory.createSimpleFieldWidget(field, widgetIsEditable);
        this.hp = new HorizontalPanel();
        this.hp.add(this.simpleWidget);
        if (widgetIsEditable) {
            if (!field.isParentLocked() || field.hasOptions()) {
                contextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
                ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(this);
                contextMenuAnchor.addClickHandler(contextMenuHandler);
                this.hp.add((Widget)contextMenuAnchor);
            }
        } else if (type == Type.ContentClass) {
            contextMenuAnchor = new ImageAnchor(this.createContextMenuImage());
            ContextMenuClickHandler contextMenuHandler = new ContextMenuClickHandler(this);
            contextMenuAnchor.addClickHandler(contextMenuHandler);
            this.hp.add((Widget)contextMenuAnchor);
        }
        this.disabledImage = new Image(bundle.getDisabledImage());
        this.enabledImage = new Image(bundle.getEnabledImage());
        if (field.isDisabled()) {
            this.disable();
        } else {
            this.enable();
        }
        this.hideInUIOnlyImage = new Image(bundle.getHideImage());
        this.hp.add((Widget)this.hideInUIOnlyImage);
        if (field.hideInUI()) {
            this.hideInUI(true);
        } else {
            this.hideInUI(false);
        }
        this.autofillImage = new Image(bundle.getGearImage());
        this.autofillImage.setTitle("Auto generated field");
        this.hp.add((Widget)this.autofillImage);
        this.refreshAutofillIcon();
        this.lockImage = new Image(bundle.getLockImage());
        this.hp.add((Widget)this.lockImage);
        if (field.isLocked() || field.isParentLocked()) {
            this.lock();
        } else {
            this.unlock();
        }
        if (field.isParentLocked()) {
            this.lockImage.setTitle("Locked by Content Class");
        }
        if (field.getParentValue() != null) {
            Image infoImage = new Image(bundle.getInfoImage());
            infoImage.setTitle("Content Class Value: " + field.getParentValue());
            this.hp.add((Widget)infoImage);
        }
        menuPanel = new PopupPanel(true);
        menuPanel.addStyleName("ContentClassPopupPanel");
        this.rootPanel.setWidget((Widget)this.hp);
    }

    public UIContentClassField getField() {
        return this.field;
    }

    public UIContentClass getContentClass() {
        return this.contentClass;
    }

    public Widget getGwtWidget() {
        return this.simpleWidget;
    }

    public void lock() {
        this.field.setLocked(true);
        this.lockImage.setVisible(true);
    }

    public void unlock() {
        this.field.setLocked(false);
        this.lockImage.setVisible(false);
    }

    public void disable() {
        this.field.setDisabled(true);
        this.hp.remove((Widget)this.enabledImage);
        this.hp.add((Widget)this.disabledImage);
    }

    public void enable() {
        this.field.setDisabled(false);
        this.hp.remove((Widget)this.disabledImage);
        this.hp.add((Widget)this.enabledImage);
    }

    public void setRequired(boolean flag) {
        this.field.setRequired(flag);
        String html = null;
        html = flag ? "<span class='nwt-FormContainer-required'>* </span>" + this.field.getDisplayName() : this.field.getDisplayName();
        html = "<span title='" + this.field.getPath() + "'>" + html + "</span>";
        this.label.setHTML(html);
    }

    private void refreshAutofillIcon() {
        this.autofillImage.setVisible(this.field.isAutofillable());
    }

    public void hideInUI(boolean hide) {
        this.field.setHideInUI(hide);
        this.hideInUIOnlyImage.setVisible(hide);
    }

    public boolean isLocked() {
        return this.field.isLocked();
    }

    public boolean canEditOptions() {
        UIContentClassField.DataType dataType = this.field.getDataType();
        return dataType != UIContentClassField.DataType.DATE && dataType != UIContentClassField.DataType.TIME;
    }

    public void refresh() {
        if (this.field.getFieldType() != this.prevFieldType) {
            this.prevFieldType = this.field.getFieldType();
            this.simpleWidget = ContentClassWidgetFactory.createSimpleFieldWidget(this.field, true);
            this.hp.remove(0);
            this.hp.insert(this.simpleWidget, 0);
        }
        if (this.simpleWidget instanceof ListBox) {
            ContentClassWidgetFactory.reloadData((ListBox)this.simpleWidget, this.field);
        } else if (this.simpleWidget instanceof ComboBoxWidget) {
            ContentClassWidgetFactory.reloadData((ComboBoxWidget<String>)((ComboBoxWidget)this.simpleWidget), this.field);
        }
        this.refreshAutofillIcon();
    }

    private Image createContextMenuImage() {
        Image img = new Image(bundle.contextMenuImage());
        img.addStyleName("ContextMenuImage");
        return img;
    }

    protected void onUnload() {
        menuPanel.hide();
        super.onUnload();
    }

    private static class ContextMenuClickHandler
    implements ClickHandler {
        private ContentClassFieldWidget widget;

        public ContextMenuClickHandler(ContentClassFieldWidget widget) {
            this.widget = widget;
        }

        public void onClick(ClickEvent event) {
            menuPanel.clear();
            int x = event.getNativeEvent().getClientX() + Window.getScrollLeft();
            int y = event.getNativeEvent().getClientY() + Window.getScrollTop();
            menuPanel.setPopupPosition(x, y);
            MenuBar menu = new MenuBar(true);
            if (!this.widget.getField().isParentLocked()) {
                if (this.widget.isLocked()) {
                    menu.addItem("Unlock", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.unlock();
                            menuPanel.hide();
                        }
                    });
                } else {
                    menu.addItem("Lock", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.lock();
                            menuPanel.hide();
                        }
                    });
                }
            }
            if (this.widget.type == Type.ContentClass) {
                if (this.widget.getField().isDisabled()) {
                    menu.addItem("Enable", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.enable();
                            menuPanel.hide();
                        }
                    });
                } else {
                    menu.addItem("Disable", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.disable();
                            menuPanel.hide();
                        }
                    });
                }
            }
            if (this.widget.type == Type.ContentClass) {
                if (this.widget.getField().hideInUI()) {
                    menu.addItem("Show in UI", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.hideInUI(false);
                            menuPanel.hide();
                        }
                    });
                } else {
                    menu.addItem("Hide in UI", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.hideInUI(true);
                            menuPanel.hide();
                        }
                    });
                }
            }
            if (this.widget.type == Type.ContentClass) {
                if (this.widget.getField().isRequired()) {
                    menu.addItem("Make Optional", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.setRequired(false);
                            menuPanel.hide();
                        }
                    });
                } else {
                    menu.addItem("Make Required", (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            widget.setRequired(true);
                            menuPanel.hide();
                        }
                    });
                }
            }
            if (this.widget.type == Type.ContentClass) {
                menu.addItem("Properties...", (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        menuPanel.hide();
                        FieldPropertiesDialog dialog = new FieldPropertiesDialog(widget);
                        dialog.center();
                    }
                });
            }
            if (this.widget.type == Type.ContentClassPartner && this.widget.field.getOptions() != null) {
                menu.addItem("Edit Options...", (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        menuPanel.hide();
                        PartnerFieldPropertiesDialog dialog = new PartnerFieldPropertiesDialog(widget);
                        dialog.center();
                    }
                });
            }
            menuPanel.add((Widget)menu);
            menuPanel.show();
        }
    }

    public static enum Type {
        ContentClass,
        ContentClassPartner;

    }
}

