/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ContentClassValidator;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;

public class ContentClassValueChangeHandler
implements ValueChangeHandler<String>,
ChangeHandler {
    private static final String ERROR_STYLE = "WidgetValidationError";
    private UIContentClassField field;

    public ContentClassValueChangeHandler(UIContentClassField field) {
        this.field = field;
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        Widget widget = (Widget)event.getSource();
        String value = (String)event.getValue();
        this.setValueAndValidate(widget, value);
    }

    public void onChange(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof ListBox) {
            ListBox listBox = (ListBox)source;
            int idx = listBox.getSelectedIndex();
            if (idx >= 0) {
                String value = listBox.getValue(idx);
                this.field.setValue(value);
            }
        } else if (source instanceof ComboBoxWidget) {
            ComboBoxWidget comboBox = (ComboBoxWidget)source;
            String value = comboBox.getText();
            this.field.setValue(value);
        }
    }

    private void setValueAndValidate(Widget widget, String value) {
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() < 1) {
            this.field.setValue(null);
            widget.removeStyleName(ERROR_STYLE);
            return;
        }
        this.field.setValue(value);
        if (this.field.getDataType() == UIContentClassField.DataType.INTEGER) {
            try {
                Long.parseLong(value);
                widget.removeStyleName(ERROR_STYLE);
            }
            catch (Exception exception) {
                widget.addStyleName(ERROR_STYLE);
            }
        } else if (this.field.getDataType() == UIContentClassField.DataType.FLOAT) {
            try {
                Float.parseFloat(value);
                widget.removeStyleName(ERROR_STYLE);
            }
            catch (Exception exception) {
                widget.addStyleName(ERROR_STYLE);
            }
        } else if (this.field.getDataType() == UIContentClassField.DataType.TIME) {
            if (this.field.isTimeCodeType()) {
                if (ContentClassValidator.isTimeCodeValid(value)) {
                    widget.removeStyleName(ERROR_STYLE);
                } else {
                    widget.addStyleName(ERROR_STYLE);
                }
            } else {
                try {
                    String dispFormat = this.field.getDisplayFormat();
                    String formatString = dispFormat == null || dispFormat.isEmpty() ? "HH:mm:ss" : dispFormat;
                    DateTimeFormat displayFormat = DateTimeFormat.getFormat((String)formatString);
                    displayFormat.parseStrict(value);
                    widget.removeStyleName(ERROR_STYLE);
                }
                catch (Exception exception) {
                    widget.addStyleName(ERROR_STYLE);
                }
            }
        }
    }
}

