/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.CCDateWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassDateValueChangeHandler;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassValueChangeHandler;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DatePickerWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import java.util.List;
import java.util.Set;

public class ContentClassWidgetFactory {
    private static DataTypeWidgetMessages messages = (DataTypeWidgetMessages)GWT.create(DataTypeWidgetMessages.class);
    private static final String ERROR_STYLE = "WidgetValidationError";
    private static final String READ_ONLY_STYLE = "WidgetReadOnly";

    public static Widget createSimpleFieldWidget(UIContentClassField field, boolean isEditable) {
        if (field.getDataType() == UIContentClassField.DataType.DATE) {
            return ContentClassWidgetFactory.createDateWidget(field, isEditable);
        }
        if (field.getDataType() == UIContentClassField.DataType.TIME) {
            return ContentClassWidgetFactory.createTimeWidget(field, isEditable);
        }
        if (field.getDataType() == UIContentClassField.DataType.BOOLEAN) {
            return ContentClassWidgetFactory.createBooleanWidget(field, isEditable);
        }
        if (field.getDataType() == UIContentClassField.DataType.INTEGER) {
            return ContentClassWidgetFactory.createIntegerWidget(field, isEditable);
        }
        if (field.getDataType() == UIContentClassField.DataType.FLOAT) {
            return ContentClassWidgetFactory.createFloatWidget(field, isEditable);
        }
        if (field.getDataType() == UIContentClassField.DataType.STRING) {
            return ContentClassWidgetFactory.createStringWidget(field, isEditable);
        }
        return new Label();
    }

    private static Widget createDateWidget(UIContentClassField field, boolean isEditable) {
        String displayFormatPattern = field.getDisplayFormat();
        if (displayFormatPattern == null || displayFormatPattern.trim().length() == 0) {
            displayFormatPattern = messages.dateWidgetFormat();
        }
        DateTimeFormat displayFormat = DateTimeFormat.getFormat((String)displayFormatPattern);
        DateTimeFormat inputFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
        DateConverter dateConverter = new DateConverter(inputFormat.getPattern(), displayFormat.getPattern());
        CCDateWidget dateBox = new CCDateWidget((DatePicker)new DatePickerWidget(), null, (IDateConverter)dateConverter);
        dateBox.setEnabled(isEditable);
        if (!isEditable) {
            dateBox.addStyleName(READ_ONLY_STYLE);
        }
        if (isEditable) {
            ContentClassDateValueChangeHandler handler = new ContentClassDateValueChangeHandler(field);
            dateBox.addValueChangeHandler(handler);
        }
        if (field.isValid()) {
            dateBox.setValue(field.getValue());
        } else {
            dateBox.setTextValue(field.getValue());
        }
        dateBox.setTitle(messages.dateWidgetToolTip(displayFormatPattern));
        return dateBox;
    }

    private static Widget createTimeWidget(UIContentClassField field, boolean isEditable) {
        String displayFormatPattern = field.getDisplayFormat();
        if (displayFormatPattern == null || displayFormatPattern.trim().length() == 0) {
            displayFormatPattern = messages.timeWidgetFormat();
        }
        TextBox textBox = new TextBox();
        textBox.setEnabled(isEditable);
        if (!isEditable) {
            textBox.addStyleName(READ_ONLY_STYLE);
        }
        if (field.isValid()) {
            if (!field.isEmpty()) {
                if (field.isTimeCodeType()) {
                    textBox.setValue((Object)field.getValue());
                } else {
                    textBox.setValue((Object)field.getValue());
                }
            }
        } else {
            textBox.setValue((Object)field.getValue());
            textBox.addStyleName(ERROR_STYLE);
        }
        if (isEditable) {
            ContentClassValueChangeHandler changeHandler = new ContentClassValueChangeHandler(field);
            textBox.addValueChangeHandler((ValueChangeHandler)changeHandler);
        }
        if (field.isTimeCodeType()) {
            textBox.setTitle(messages.timeCodeWidgetToolTip());
        } else {
            textBox.setTitle(messages.timeWidgetToolTip(displayFormatPattern));
        }
        return textBox;
    }

    private static Widget createFloatWidget(UIContentClassField field, boolean isEditable) {
        Widget widget = ContentClassWidgetFactory.createStringWidget(field, isEditable);
        widget.setTitle(messages.floatWidgetToolTip());
        if (!field.isValid()) {
            widget.addStyleName(ERROR_STYLE);
        }
        return widget;
    }

    private static Widget createIntegerWidget(UIContentClassField field, boolean isEditable) {
        Widget widget = ContentClassWidgetFactory.createStringWidget(field, isEditable);
        widget.setTitle(messages.integerWidgetToolTip());
        if (!field.isValid()) {
            widget.addStyleName(ERROR_STYLE);
        }
        return widget;
    }

    private static Widget createStringWidget(UIContentClassField field, boolean isEditable) {
        UIContentClassField.FieldType fieldType;
        ContentClassValueChangeHandler changeHandler = null;
        if (isEditable) {
            changeHandler = new ContentClassValueChangeHandler(field);
        }
        if ((fieldType = field.getFieldType()) == UIContentClassField.FieldType.DROP_DOWN) {
            ListBox listBox = new ListBox();
            listBox.setVisibleItemCount(1);
            field.getOptions();
            ContentClassWidgetFactory.reloadData(listBox, field);
            if (isEditable) {
                listBox.addChangeHandler((ChangeHandler)changeHandler);
            } else {
                listBox.addStyleName(READ_ONLY_STYLE);
            }
            listBox.setTitle(messages.stringWidgetToolTip());
            listBox.setEnabled(isEditable);
            return listBox;
        }
        if (fieldType == UIContentClassField.FieldType.COMBO_BOX) {
            ComboBoxWidget comboBox = new ComboBoxWidget();
            ContentClassWidgetFactory.reloadData((ComboBoxWidget<String>)comboBox, field);
            comboBox.setTitle(messages.stringWidgetToolTip());
            comboBox.setEnabled(isEditable);
            if (isEditable) {
                comboBox.addChangeHandler((ChangeHandler)changeHandler);
            } else {
                comboBox.addStyleName(READ_ONLY_STYLE);
            }
            return comboBox;
        }
        if (field.getFieldType() == UIContentClassField.FieldType.TEXT_AREA) {
            TextArea textArea = new TextArea();
            textArea.setVisibleLines(4);
            textArea.setText(field.getValue());
            if (isEditable) {
                textArea.addValueChangeHandler((ValueChangeHandler)changeHandler);
            }
            textArea.setTitle(messages.stringWidgetToolTip());
            textArea.setEnabled(isEditable);
            if (!isEditable) {
                textArea.addStyleName(READ_ONLY_STYLE);
            }
            return textArea;
        }
        TextBox textBox = new TextBox();
        textBox.setText(field.getValue());
        if (isEditable) {
            textBox.addValueChangeHandler((ValueChangeHandler)changeHandler);
        }
        textBox.setTitle(messages.stringWidgetToolTip());
        textBox.setEnabled(isEditable);
        if (!isEditable) {
            textBox.addStyleName(READ_ONLY_STYLE);
        }
        return textBox;
    }

    private static Widget createBooleanWidget(UIContentClassField field, boolean isEditable) {
        ListBox listBox = new ListBox();
        listBox.setVisibleItemCount(1);
        if (field.hasOptions()) {
            ContentClassWidgetFactory.reloadData(listBox, field);
        } else {
            listBox.addItem("", "");
            listBox.addItem(messages.booleanWidgetTrueValue(), "true");
            listBox.addItem(messages.booleanWidgetFalseValue(), "false");
            if ("true".equals(field.getValue())) {
                listBox.setSelectedIndex(1);
            } else if ("false".equals(field.getValue())) {
                listBox.setSelectedIndex(2);
            }
        }
        if (isEditable) {
            ContentClassValueChangeHandler changeHandler = new ContentClassValueChangeHandler(field);
            listBox.addChangeHandler((ChangeHandler)changeHandler);
        }
        listBox.setTitle(messages.booleanWidgetToolTip());
        listBox.setEnabled(isEditable);
        if (!isEditable) {
            listBox.addStyleName(READ_ONLY_STYLE);
        }
        return listBox;
    }

    public static void reloadData(ListBox listBox, UIContentClassField field) {
        if (listBox == null || field == null) {
            return;
        }
        List<KeyValuePair> options = field.getOptions();
        Set<String> excludedKeys = field.getFilteredOptionKeys();
        String selectedValue = field.getValue();
        listBox.clear();
        listBox.addItem("", "");
        if (options != null) {
            for (KeyValuePair item : options) {
                if (excludedKeys != null && excludedKeys.contains(item.getValue())) continue;
                listBox.addItem(item.getKey(), item.getValue());
                if (!item.getValue().equals(selectedValue)) continue;
                listBox.setSelectedIndex(listBox.getItemCount() - 1);
            }
        }
    }

    public static void reloadData(ComboBoxWidget<String> comboBox, UIContentClassField field) {
        if (comboBox == null || field == null) {
            return;
        }
        List<KeyValuePair> options = field.getOptions();
        Set<String> excludedKeys = field.getFilteredOptionKeys();
        String selectedValue = field.getValue();
        comboBox.clear();
        if (options != null) {
            for (KeyValuePair item : options) {
                if (excludedKeys != null && excludedKeys.contains(item.getValue())) continue;
                comboBox.addItem(item.getKey(), (Object)item.getValue());
                if (!item.getValue().equals(selectedValue)) continue;
                comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
            }
        }
        comboBox.setText(field.getValue());
    }
}

