/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.customfield.util;

import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CustomFieldUtil {
    public static <T> List getDuplicate(Collection<T> list) {
        final ArrayList duplicatedObjects = new ArrayList();
        HashSet set = new HashSet<T>(){

            @Override
            public boolean add(T e) {
                if (this.contains(e)) {
                    duplicatedObjects.add(e);
                }
                return super.add(e);
            }
        };
        for (T t : list) {
            set.add(t);
        }
        return duplicatedObjects;
    }

    public static <T> boolean hasDuplicate(Collection<T> list) {
        return !CustomFieldUtil.getDuplicate(list).isEmpty();
    }

    public static boolean hasDuplicatesManyAssets(List<UICustomField> fieldList) {
        final ArrayList duplList = new ArrayList();
        HashSet<UICustomField> set = new HashSet<UICustomField>(){

            @Override
            public boolean add(UICustomField e) {
                if (this.contains(e)) {
                    duplList.add(e);
                }
                return super.add(e);
            }
        };
        for (UICustomField field : fieldList) {
            set.add(field);
        }
        return false;
    }

    public static String getDuplicatesMessage(List<UICustomField> duplicates) {
        String duplString = "";
        for (UICustomField field : duplicates) {
            duplString = String.valueOf(duplString) + field.getAssetPath() + " : " + field.getName() + "\n";
        }
        return duplString;
    }

    public static String getDuplicateMessage(List<UICustomFieldGroup> duplicates) {
        String duplString = "";
        for (UICustomFieldGroup group : duplicates) {
            duplString = String.valueOf(duplString) + group.getAssetPath() + " : " + group.getDisplayName() + "\n";
        }
        return duplString;
    }

    public static String convert(boolean value) {
        String token = value ? "Y" : "N";
        return token;
    }

    public static boolean convertToBoolean(String field) {
        return field != null && field.equalsIgnoreCase("Y");
    }
}

