/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.customfield.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.customfield.enums.CustomFieldDataType;
import com.tandbergtv.cms.portal.content.client.customfield.enums.FieldTypeOptionsEnum;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAsset;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewService;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.customfield.view.NameHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import java.util.ArrayList;
import java.util.List;

public class CustomFieldGroupsView
extends Composite {
    private UICustomFieldAsset assetDisplayed;
    private VerticalPanel multiGroupsPanel;
    private HorizontalPanel groupButtonPanel;
    private Button btnAddGroup;
    private static final int SCROLL_CUT = 240;
    private static final int SCROLL_CUT_BOTTOM = 40;
    private static final int SCROLL_WIDTH_CUT = 300;
    public static final String STYLE_CATEGORY_METADATA_AREA = "customField-area";
    private ICustomFieldViewServiceAsync viewService;
    private MessageArea messageContainer;
    final ScrollContainer dataScroll = new ScrollContainer();
    ScrollPanel assetScroll;
    boolean refresh = false;
    private static final String CUSTOM_FIELD_TABLE_STYLE = "custom-field-table";

    public CustomFieldGroupsView(final UICustomFieldAsset assetDisplayed, boolean refresh, final ScrollPanel assetScroll, MessageArea messageContainer) {
        this.messageContainer = messageContainer;
        this.refresh = refresh;
        this.viewService = (ICustomFieldViewServiceAsync)GWT.create(ICustomFieldViewService.class);
        this.assetScroll = assetScroll;
        this.assetDisplayed = assetDisplayed;
        this.multiGroupsPanel = new VerticalPanel();
        this.groupButtonPanel = new HorizontalPanel();
        this.btnAddGroup = new Button("Add Group");
        this.btnAddGroup.removeStyleName("gwt-Button");
        this.btnAddGroup.addStyleName("ebBtn");
        this.btnAddGroup.addStyleName("addgroup_button_icon");
        this.dataScroll.addStyleName(STYLE_CATEGORY_METADATA_AREA);
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"})) {
            this.btnAddGroup.setVisible(false);
        }
        this.setDataScrollSize();
        this.setAssetScrollSize();
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                int height = event.getHeight();
                int width = event.getWidth();
                CustomFieldGroupsView.this.setResizeSize(height, width, assetScroll);
            }
        });
        this.btnAddGroup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomFieldGroupsView.this.showGroupBox();
            }
        });
        final List<UICustomFieldGroup> groupList = assetDisplayed.getGroupList();
        if (groupList != null && !groupList.isEmpty()) {
            for (final UICustomFieldGroup group : groupList) {
                Label groupDisplayNameLbl = new Label("Display Name");
                Label fieldsLbl = new Label("Fields");
                HorizontalContainer headingPanel = new HorizontalContainer();
                headingPanel.addStyleName("content-ComplexFieldWidget-disclosureHeader");
                LabelWidget headingLabel = new LabelWidget(group.getDisplayName());
                headingLabel.addStyleName("content-ComplexFieldWidget-disclosureHeader-label");
                headingPanel.add((Widget)headingLabel);
                headingPanel.setWidth("100%");
                Button btnDeleteGroup = new Button("-");
                btnDeleteGroup.removeStyleName("gwt-Button");
                btnDeleteGroup.addStyleName("ebBtn");
                btnDeleteGroup.addStyleName("minus_button_icon");
                headingPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                headingPanel.add((Widget)btnDeleteGroup);
                if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"})) {
                    btnDeleteGroup.setVisible(false);
                }
                final RoundedDisclosureContainer groupContainer = new RoundedDisclosureContainer((Widget)headingPanel, true);
                groupContainer.setAnimationEnabled(true);
                groupContainer.setOpen(true);
                VerticalPanel groupV = new VerticalPanel();
                final TextBox groupDisplayNameTxt = new TextBox();
                groupDisplayNameTxt.setText(group.getDisplayName());
                groupDisplayNameTxt.setWidth("250px");
                groupDisplayNameTxt.setMaxLength(255);
                groupDisplayNameTxt.addKeyUpHandler(new KeyUpHandler(){

                    public void onKeyUp(KeyUpEvent event) {
                        group.setDisplayName(groupDisplayNameTxt.getText());
                        group.setAssetPath(assetDisplayed.getAssetPath());
                    }
                });
                FlexTable groupTable = new FlexTable();
                groupTable.setWidget(0, 0, (Widget)groupDisplayNameLbl);
                groupTable.setWidget(0, 1, (Widget)groupDisplayNameTxt);
                groupTable.setWidget(1, 0, (Widget)fieldsLbl);
                groupV.add((Widget)groupTable);
                FlexTableContainer fieldsTable = new FlexTableContainer();
                fieldsTable.addStyleName("content-AssetContentTable");
                fieldsTable.addStyleDependentName(CUSTOM_FIELD_TABLE_STYLE);
                this.buildTableHeader((FlexTable)fieldsTable);
                List<UICustomField> fieldList = group.getFieldList();
                if (fieldList != null && !fieldList.isEmpty()) {
                    int rowCounter = 1;
                    for (UICustomField field : fieldList) {
                        this.setFieldTableRow(field, rowCounter, (FlexTable)fieldsTable);
                        ++rowCounter;
                    }
                    UICustomField lastField = fieldList.get(fieldList.size() - 1);
                    if (lastField.getName() != null && !lastField.getName().isEmpty()) {
                        UICustomField defaultField = new UICustomField();
                        defaultField.setGroup(group);
                        group.addFieldList(defaultField);
                        this.setFieldTableRow(defaultField, rowCounter, (FlexTable)fieldsTable);
                    }
                    groupV.add((Widget)fieldsTable);
                } else {
                    UICustomField emptyField = new UICustomField();
                    emptyField.setGroup(group);
                    group.addFieldList(emptyField);
                    this.setFieldTableRow(emptyField, 1, (FlexTable)fieldsTable);
                    groupV.add((Widget)fieldsTable);
                }
                groupContainer.add((Widget)groupV);
                this.multiGroupsPanel.add((Widget)groupContainer);
                this.groupButtonPanel.add((Widget)this.btnAddGroup);
                this.multiGroupsPanel.add((Widget)this.groupButtonPanel);
                this.multiGroupsPanel.setSpacing(8);
                btnDeleteGroup.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        groupList.remove(group);
                        groupContainer.setVisible(false);
                    }
                });
            }
        } else {
            this.multiGroupsPanel.add((Widget)this.btnAddGroup);
            this.multiGroupsPanel.setSpacing(8);
        }
        this.dataScroll.clear();
        this.dataScroll.add((Widget)this.multiGroupsPanel);
        this.initWidget((Widget)this.dataScroll);
    }

    public ScrollPanel getAssetScroll() {
        return this.assetScroll;
    }

    public void setAssetScrollSize() {
        this.assetScroll.setWidth("225");
        SimplePanel assetPanel = (SimplePanel)this.assetScroll.getWidget();
        int assetPanelHeight = Window.getClientHeight() - 240 - this.messageContainer.getOffsetHeight() - 40;
        assetPanel.setHeight(String.valueOf(String.valueOf(assetPanelHeight)) + "px");
    }

    public void setDataScrollSize() {
        int n = Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - 300;
        this.dataScroll.setHeight(String.valueOf(String.valueOf(Window.getClientHeight() - 240 - this.messageContainer.getOffsetHeight() - 40)) + "px");
        this.dataScroll.setWidth(String.valueOf(String.valueOf(Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - 300)) + "px");
    }

    public UICustomFieldAsset getAssetDisplayed() {
        return this.assetDisplayed;
    }

    private void buildTableHeader(FlexTable fieldsTable) {
        fieldsTable.setWidget(0, 0, (Widget)new LabelWidget("Name"));
        fieldsTable.setWidget(0, 1, (Widget)new LabelWidget("Display Name"));
        fieldsTable.setWidget(0, 2, (Widget)new LabelWidget("Datatype"));
        fieldsTable.setWidget(0, 3, (Widget)new LabelWidget("Field Type"));
        fieldsTable.setWidget(0, 4, (Widget)new LabelWidget("Multivalue"));
        fieldsTable.setWidget(0, 5, (Widget)new LabelWidget("Job Parameter"));
        fieldsTable.setWidget(0, 6, (Widget)new LabelWidget("Schedule Parameter"));
        fieldsTable.setWidget(0, 7, (Widget)new LabelWidget("Delete"));
        int i = 0;
        while (i <= 7) {
            fieldsTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
            fieldsTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
            Widget widget = fieldsTable.getWidget(0, i);
            if (widget instanceof LabelWidget) {
                widget.addStyleName("content-AssetContentTable-header-text");
            }
            ++i;
        }
        fieldsTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
        fieldsTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");
    }

    private void showGroupBox() {
        final UICustomFieldGroup group = new UICustomFieldGroup();
        this.assetDisplayed.addGroup(group);
        group.setAssetPath(this.assetDisplayed.getAssetPath());
        HorizontalContainer headingPanel = new HorizontalContainer();
        headingPanel.addStyleName("content-ComplexFieldWidget-disclosureHeader");
        LabelWidget headingLabel = new LabelWidget(group.getDisplayName());
        headingLabel.addStyleName("content-ComplexFieldWidget-disclosureHeader-label");
        headingPanel.add((Widget)headingLabel);
        headingPanel.setWidth("100%");
        Button btnDeleteGroup = new Button("-");
        btnDeleteGroup.removeStyleName("gwt-Button");
        btnDeleteGroup.addStyleName("ebBtn");
        btnDeleteGroup.addStyleName("minus_button_icon");
        headingPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        headingPanel.add((Widget)btnDeleteGroup);
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"})) {
            btnDeleteGroup.setVisible(false);
        }
        final RoundedDisclosureContainer groupContainer = new RoundedDisclosureContainer((Widget)headingPanel);
        groupContainer.setAnimationEnabled(true);
        groupContainer.setOpen(true);
        groupContainer.setWidth("100%");
        VerticalPanel groupV = new VerticalPanel();
        Label groupDisplayNameLbl = new Label("Display Name");
        Label fieldsLbl = new Label("Fields");
        final TextBox groupDisplayNameTxt = new TextBox();
        groupDisplayNameTxt.setText(group.getDisplayName());
        groupDisplayNameTxt.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                group.setDisplayName(groupDisplayNameTxt.getText());
                group.setAssetPath(CustomFieldGroupsView.this.assetDisplayed.getAssetPath());
            }
        });
        groupDisplayNameTxt.setWidth("250px");
        groupDisplayNameTxt.setMaxLength(255);
        FlexTable groupTable = new FlexTable();
        groupTable.removeAllRows();
        groupTable.setWidget(0, 0, (Widget)groupDisplayNameLbl);
        groupTable.setWidget(0, 1, (Widget)groupDisplayNameTxt);
        groupTable.setWidget(1, 0, (Widget)fieldsLbl);
        groupV.remove((Widget)groupTable);
        groupV.add((Widget)groupTable);
        UICustomField field = new UICustomField();
        FlexTableContainer fieldsTable = new FlexTableContainer();
        fieldsTable.addStyleName("content-AssetContentTable");
        fieldsTable.addStyleDependentName(CUSTOM_FIELD_TABLE_STYLE);
        this.buildTableHeader((FlexTable)fieldsTable);
        group.addFieldList(field);
        field.setGroup(group);
        this.setFieldTableRow(field, 1, (FlexTable)fieldsTable);
        groupV.add((Widget)fieldsTable);
        groupContainer.add((Widget)groupV);
        this.multiGroupsPanel.add((Widget)groupContainer);
        this.groupButtonPanel.add((Widget)this.btnAddGroup);
        this.multiGroupsPanel.add((Widget)this.groupButtonPanel);
        this.multiGroupsPanel.setSpacing(8);
        btnDeleteGroup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomFieldGroupsView.this.assetDisplayed.getGroupList().remove(group);
                groupContainer.setVisible(false);
            }
        });
    }

    private void setFieldTableRow(final UICustomField field, int row, final FlexTable fieldsTable) {
        fieldsTable.getRowFormatter().addStyleName(row, "content-AssetContentTable-row");
        fieldsTable.getRowFormatter().addStyleName(row, "content-AssetContentTable-row-body");
        ImageWidget image = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        final PushButtonWidget deleteButton = new PushButtonWidget(image);
        deleteButton.addStyleName("content-AssetContent-deleteButton");
        deleteButton.setEnabled(true);
        deleteButton.setVisible(true);
        CheckBox scheduleParameter = new CheckBox();
        final TextBox name = new TextBox();
        name.setText(field.getName());
        name.setWidth("180px");
        name.setMaxLength(255);
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"}) && name.isReadOnly()) {
            deleteButton.setVisible(false);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"})) {
            name.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    field.setName(name.getText());
                }
            });
            final NameHandler nameHandler = new NameHandler();
            nameHandler.setRegistration(name.addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    field.setName(name.getText());
                    if (field.getName() != null && field.getName().length() >= 1) {
                        UICustomField uiField = new UICustomField();
                        uiField.setGroup(field.getGroup());
                        field.getGroup().addFieldList(uiField);
                        fieldsTable.setWidget(fieldsTable.getRowCount() - 1, 7, (Widget)deleteButton);
                        CustomFieldGroupsView.this.addFieldTableRow(fieldsTable, uiField);
                        nameHandler.getRegistration().removeHandler();
                    }
                }
            }));
        }
        ArrayList<String> fieldTypeList = new ArrayList<String>();
        ListBox fieldTypeBox = new ListBox();
        this.setFieldTypeBox(fieldTypeList, fieldTypeBox, field);
        final ArrayList<String> typeList = new ArrayList<String>();
        final ListBox typeBox = new ListBox();
        this.setDatatypeBox(typeList, typeBox, field, scheduleParameter, fieldTypeList, fieldTypeBox);
        if (field.getName() != null && !field.getName().isEmpty()) {
            this.viewService.isValidField(field.getName(), field.getDisplayName(), field.getAssetPath(), field.getGroup().getDisplayName(), new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        if (field.getId() > 0L) {
                            name.setReadOnly(true);
                            name.setEnabled(false);
                        }
                        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_Administer"})) {
                            deleteButton.setVisible(false);
                        }
                        int index = typeList.indexOf(field.getDataType());
                        typeBox.setSelectedIndex(index);
                        typeBox.setEnabled(false);
                    }
                }
            });
        }
        final TextBox displayName = new TextBox();
        displayName.setText(field.getDisplayName());
        displayName.setWidth("180px");
        displayName.setMaxLength(255);
        displayName.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                field.setDisplayName(displayName.getText());
            }
        });
        CheckBox multiValue = new CheckBox();
        multiValue.setValue(Boolean.valueOf(field.isMultiValue()));
        multiValue.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                boolean checked = ((CheckBox)sender).isChecked();
                field.setMultiValue(checked);
            }
        });
        CheckBox jobParameter = new CheckBox();
        jobParameter.setValue(Boolean.valueOf(field.isJobParameter()));
        jobParameter.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                boolean checked = ((CheckBox)sender).isChecked();
                field.setJobParameter(checked);
            }
        });
        scheduleParameter.setValue(Boolean.valueOf(field.isJobScheduleParameter()));
        scheduleParameter.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                boolean checked = ((CheckBox)sender).isChecked();
                field.setJobScheduleParameter(checked);
            }
        });
        if (field.getDataType() != null && !field.getDataType().equalsIgnoreCase(CustomFieldDataType.DATE.toString())) {
            scheduleParameter.setEnabled(false);
        }
        fieldsTable.setWidget(row, 0, (Widget)name);
        fieldsTable.setWidget(row, 1, (Widget)displayName);
        fieldsTable.setWidget(row, 2, (Widget)typeBox);
        fieldsTable.setWidget(row, 3, (Widget)fieldTypeBox);
        fieldsTable.setWidget(row, 4, (Widget)multiValue);
        fieldsTable.setWidget(row, 5, (Widget)jobParameter);
        fieldsTable.setWidget(row, 6, (Widget)scheduleParameter);
        if (field.getName() != null) {
            fieldsTable.setWidget(row, 7, (Widget)deleteButton);
        }
        int i = 3;
        while (i <= 7) {
            fieldsTable.getFlexCellFormatter().setHorizontalAlignment(row, i, HasHorizontalAlignment.ALIGN_CENTER);
            fieldsTable.getCellFormatter().addStyleName(row, i, "content-AssetContentTable-cell");
            fieldsTable.getCellFormatter().addStyleName(row, i, "content-AssetContentTable-cell-body");
            ++i;
        }
        deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                field.setCompareById(true);
                field.getGroup().getFieldList().remove(field);
                field.setCompareById(false);
                HTMLTable.Cell cell = fieldsTable.getCellForEvent(event);
                int x = cell.getRowIndex();
                fieldsTable.removeRow(x);
                int count = fieldsTable.getRowCount();
                if (count == 2) {
                    CustomFieldGroupsView.this.buildTableHeader(fieldsTable);
                }
            }
        });
    }

    private void setDatatypeBox(List<String> typeList, final ListBox typeBox, final UICustomField field, final CheckBox scheduleParameter, final List<String> fieldTypeList, final ListBox fieldTypeBox) {
        CustomFieldDataType[] customFieldDataTypeArray = CustomFieldDataType.values();
        int n = customFieldDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomFieldDataType dataType = customFieldDataTypeArray[n2];
            typeBox.addItem(dataType.toString());
            typeList.add(dataType.toString());
            ++n2;
        }
        if (field.getDataType() != null) {
            int index = typeList.indexOf(field.getDataType());
            typeBox.setSelectedIndex(index);
        } else {
            typeBox.setSelectedIndex(0);
            field.setDataType(CustomFieldDataType.STRING.toString());
        }
        typeBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                int index = typeBox.getSelectedIndex();
                String value = typeBox.getValue(index);
                field.setDataType(value);
                if (!value.equalsIgnoreCase(CustomFieldDataType.DATE.toString())) {
                    scheduleParameter.setValue(Boolean.valueOf(false));
                    scheduleParameter.setEnabled(false);
                } else {
                    scheduleParameter.setEnabled(true);
                }
                if (value.equalsIgnoreCase(CustomFieldDataType.BOOLEAN.toString())) {
                    fieldTypeBox.clear();
                    fieldTypeBox.addItem(FieldTypeOptionsEnum.DROP_DOWN.getName());
                    fieldTypeBox.setSelectedIndex(0);
                    field.setFieldType(FieldTypeOptionsEnum.DROP_DOWN.getId());
                } else if (value.equalsIgnoreCase(CustomFieldDataType.DATE.toString()) || value.equalsIgnoreCase(CustomFieldDataType.TIME.toString())) {
                    fieldTypeBox.clear();
                    FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                    int n = fieldTypeOptionsEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n2];
                        if (!option.equals((Object)FieldTypeOptionsEnum.COMBO_BOX)) {
                            fieldTypeBox.addItem(option.getName());
                            fieldTypeList.add(option.getName());
                        }
                        ++n2;
                    }
                    fieldTypeBox.setSelectedIndex(0);
                    field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
                } else if (value.equalsIgnoreCase(CustomFieldDataType.STRING.toString())) {
                    fieldTypeBox.clear();
                    FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                    int n = fieldTypeOptionsEnumArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n3];
                        fieldTypeBox.addItem(option.getName());
                        fieldTypeList.add(option.getName());
                        ++n3;
                    }
                    fieldTypeBox.setSelectedIndex(0);
                    field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
                } else {
                    fieldTypeBox.clear();
                    FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                    int n = fieldTypeOptionsEnumArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n4];
                        if (!option.equals((Object)FieldTypeOptionsEnum.TEXT_AREA)) {
                            fieldTypeBox.addItem(option.getName());
                            fieldTypeList.add(option.getName());
                        }
                        ++n4;
                    }
                    fieldTypeBox.setSelectedIndex(0);
                    field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
                }
            }
        });
    }

    private void setFieldTypeBox(List<String> fieldTypeList, final ListBox fieldTypeBox, final UICustomField field) {
        if (field.getDataType() != null) {
            if (field.getDataType().equalsIgnoreCase(CustomFieldDataType.BOOLEAN.toString())) {
                fieldTypeBox.clear();
                fieldTypeBox.addItem(FieldTypeOptionsEnum.DROP_DOWN.getName());
                fieldTypeBox.setSelectedIndex(0);
                field.setFieldType(FieldTypeOptionsEnum.DROP_DOWN.getId());
            } else if (field.getDataType().equalsIgnoreCase(CustomFieldDataType.STRING.toString())) {
                FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                int n = fieldTypeOptionsEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n2];
                    fieldTypeBox.addItem(option.getName());
                    fieldTypeList.add(option.getName());
                    ++n2;
                }
                if (field.getFieldType() != 0) {
                    int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
                    fieldTypeBox.setSelectedIndex(index);
                }
            } else if (field.getDataType().equalsIgnoreCase(CustomFieldDataType.DATE.toString()) || field.getDataType().equalsIgnoreCase(CustomFieldDataType.TIME.toString())) {
                FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                int n = fieldTypeOptionsEnumArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n3];
                    if (!option.equals((Object)FieldTypeOptionsEnum.COMBO_BOX)) {
                        fieldTypeBox.addItem(option.getName());
                        fieldTypeList.add(option.getName());
                    }
                    ++n3;
                }
                if (field.getFieldType() != 0) {
                    int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
                    fieldTypeBox.setSelectedIndex(index);
                }
            } else {
                FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
                int n = fieldTypeOptionsEnumArray.length;
                int n4 = 0;
                while (n4 < n) {
                    FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n4];
                    if (!option.equals((Object)FieldTypeOptionsEnum.TEXT_AREA)) {
                        fieldTypeBox.addItem(option.getName());
                        fieldTypeList.add(option.getName());
                    }
                    ++n4;
                }
                if (field.getFieldType() != 0) {
                    int index = fieldTypeList.indexOf(FieldTypeOptionsEnum.fromId(field.getFieldType()).getName());
                    fieldTypeBox.setSelectedIndex(index);
                }
            }
        } else {
            FieldTypeOptionsEnum[] fieldTypeOptionsEnumArray = FieldTypeOptionsEnum.values();
            int n = fieldTypeOptionsEnumArray.length;
            int n5 = 0;
            while (n5 < n) {
                FieldTypeOptionsEnum option = fieldTypeOptionsEnumArray[n5];
                fieldTypeBox.addItem(option.getName());
                fieldTypeList.add(option.getName());
                ++n5;
            }
            fieldTypeBox.setSelectedIndex(0);
            field.setFieldType(FieldTypeOptionsEnum.TEXT_BOX.getId());
        }
        fieldTypeBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                int index = fieldTypeBox.getSelectedIndex();
                String value = fieldTypeBox.getValue(index);
                field.setFieldType(FieldTypeOptionsEnum.fromName(value).getId());
            }
        });
    }

    private void setResizeSize(int height, int width, ScrollPanel assetScroll) {
        int heightAll = Window.getClientHeight() - 240 - this.messageContainer.getOffsetHeight() - 40;
        this.dataScroll.setHeight(String.valueOf(String.valueOf(heightAll)) + "px");
        this.dataScroll.setWidth(String.valueOf(String.valueOf(Window.getClientWidth() < 900 ? 900 : Window.getClientWidth() - 300)) + "px");
        SimplePanel assetPanel = (SimplePanel)assetScroll.getWidget();
        assetPanel.setWidth(String.valueOf(String.valueOf(220)) + "px");
        int assetPanelHeight = Window.getClientHeight() - 240 - this.messageContainer.getOffsetHeight() - 40;
        assetPanel.setHeight(String.valueOf(String.valueOf(assetPanelHeight)) + "px");
        int n = Window.getClientHeight() < 650 ? assetPanelHeight + 10 : assetPanelHeight;
        assetScroll.setHeight(String.valueOf(String.valueOf(assetPanelHeight + 10)) + "px");
    }

    private void addFieldTableRow(FlexTable fieldsTable, UICustomField uiCustomField) {
        int row = fieldsTable.getRowCount() + 1;
        this.setFieldTableRow(uiCustomField, row, fieldsTable);
    }

    public MessageArea getMessageContainer() {
        return this.messageContainer;
    }

    public void setMessageContainer(MessageArea messageContainer2) {
        this.messageContainer = messageContainer2;
    }
}

