/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.customfield.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.customfield.enums.CustomFieldDataType;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomField;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAsset;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldAssetTree;
import com.tandbergtv.cms.portal.content.client.customfield.model.UICustomFieldGroup;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewService;
import com.tandbergtv.cms.portal.content.client.customfield.rpc.ICustomFieldViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.customfield.util.CustomFieldUtil;
import com.tandbergtv.cms.portal.content.client.customfield.view.CustomFieldGroupsView;
import com.tandbergtv.cms.portal.content.client.exception.CustomFieldDeleteValidationException;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CustomFieldTabView
extends Composite {
    private final SimpleContainer rootContainer;
    private SimplePanel assetsViewPanel;
    private ScrollPanel assetScroll;
    private HorizontalPanel windowPanel;
    private List<UICustomFieldGroup> groupsModified;
    private static final String STYLE_TREEITEM_SELECTED = "sites-treeItem-selected";
    private ICustomFieldViewServiceAsync viewService;
    private CustomFieldGroupsView groupsView;
    private MessageArea messageContainer;
    private Tree tree;
    UICustomFieldAssetTree assetTree = null;
    private ContentConstants myConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private BusyIndicator busyIndicator;
    private static final String DOWN_ICON = "cms_contentmgmt_ui/resources/images/child-collapseAll-normalState.png";
    private static final String UP_ICON = "cms_contentmgmt_ui/resources/images/child-expandAll-normalState.png";
    HorizontalPanel horizontalPanel;

    public CustomFieldTabView(MessageArea messageArea) {
        this.messageContainer = messageArea;
        this.messageContainer.reset();
        this.groupsModified = new ArrayList<UICustomFieldGroup>();
        this.busyIndicator = new BusyIndicator();
        this.rootContainer = new SimpleContainer();
        this.initWidget((Widget)this.rootContainer);
        this.initialize();
    }

    private void initialize() {
        this.viewService = (ICustomFieldViewServiceAsync)GWT.create(ICustomFieldViewService.class);
        this.initTree();
    }

    private void initTree() {
        this.showBusyIndicator();
        this.groupsView = null;
        this.viewService.getUIAssetTree((AsyncCallback<UICustomFieldAssetTree>)new NeptuneAsyncCallback<UICustomFieldAssetTree>(){

            public void onNeptuneFailure(Throwable caught) {
                CustomFieldTabView.this.hideBusyindicator();
                String error = caught != null ? caught.getLocalizedMessage() : "";
                Window.alert((String)("Error retrieving asset tree: " + error));
            }

            public void onNeptuneSuccess(UICustomFieldAssetTree result) {
                CustomFieldTabView.this.assetTree = result;
                CustomFieldTabView.this.buildAssetPanel(result, true);
                CustomFieldTabView.this.hideBusyindicator();
            }
        });
    }

    private void buildAssetPanel(UICustomFieldAssetTree result, boolean refresh) {
        UICustomFieldAsset pkgAsset = result.getPkgAsset();
        UICustomFieldAsset seriesAsset = result.getSeriesAsset();
        this.assetScroll = new ScrollContainer();
        this.assetsViewPanel = new SimplePanel();
        this.assetsViewPanel.addStyleName("AssetsViewPanel");
        this.assetScroll.add((Widget)this.assetsViewPanel);
        this.assetScroll.setAlwaysShowScrollBars(false);
        this.tree = new Tree();
        TreeResource images = new TreeResource();
        this.tree = new TreeWidget((Tree.Resources)images);
        TreeItem rootItem = this.buildAssetTree(pkgAsset);
        if (rootItem == null) {
            this.showError("Invalid specification for package");
            return;
        }
        this.tree.addItem(rootItem);
        rootItem.setState(true, false);
        this.tree.setSelectedItem(rootItem);
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                CustomFieldTabView.this.showAssetPanel((TreeItem)event.getSelectedItem(), false);
            }
        });
        TreeItem series = this.buildSeriesAssetTree(seriesAsset);
        this.tree.addItem(series);
        series.setState(true, false);
        if (series == null) {
            this.showError("Invalid specification for series");
            return;
        }
        this.assetsViewPanel.add((Widget)this.tree);
        LabelWidget textLabelExpand = new LabelWidget("Expand All");
        textLabelExpand.setStyleName("settings-view-expand-collapse-style");
        textLabelExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CustomFieldTabView.this.tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        LabelWidget textLabelCollapse = new LabelWidget("Collapse All");
        textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
        textLabelCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CustomFieldTabView.this.tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgCollapse = new ImageWidget(DOWN_ICON);
        dropDownImgCollapse.setStyleName("drop-arrow-asset-collapse-all");
        dropDownImgCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CustomFieldTabView.this.tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgExpand = new ImageWidget(UP_ICON);
        dropDownImgExpand.setStyleName("drop-arrow-expand-all");
        dropDownImgExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CustomFieldTabView.this.tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        this.horizontalPanel = new HorizontalPanel();
        this.horizontalPanel.add((Widget)dropDownImgExpand);
        this.horizontalPanel.add((Widget)textLabelExpand);
        this.horizontalPanel.add((Widget)dropDownImgCollapse);
        this.horizontalPanel.add((Widget)textLabelCollapse);
        this.showAssetPanel(this.tree.getItem(0), refresh);
    }

    private TreeItem buildSeriesAssetTree(UICustomFieldAsset seriesAsset) {
        TreeItem item = new TreeItem(seriesAsset.getDisplayName());
        item.setUserObject((Object)seriesAsset);
        if (seriesAsset.getAssetList() != null && !seriesAsset.getAssetList().isEmpty()) {
            this.addSeriesTreeChildren(seriesAsset, item);
        }
        return item;
    }

    private void showAssetPanel(TreeItem item, boolean refresh) {
        List<Object> currentList = new ArrayList();
        if (this.groupsView != null) {
            currentList = this.groupsView.getAssetDisplayed().getGroupList();
        }
        UICustomFieldAsset asset = (UICustomFieldAsset)item.getUserObject();
        if (this.groupsModified == null) {
            this.groupsModified = new ArrayList<UICustomFieldGroup>();
        }
        for (UICustomFieldGroup uICustomFieldGroup : currentList) {
            if (this.groupsModified.contains(uICustomFieldGroup)) continue;
            this.groupsModified.add(uICustomFieldGroup);
        }
        this.groupsView = new CustomFieldGroupsView(asset, refresh, this.assetScroll, this.messageContainer);
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.add((Widget)this.horizontalPanel);
        verticalPanel.add((Widget)this.assetScroll);
        this.windowPanel = new HorizontalPanel();
        this.windowPanel.add((Widget)verticalPanel);
        this.windowPanel.add((Widget)this.groupsView);
        this.rootContainer.setWidget((Widget)this.windowPanel);
    }

    public void showError(String error) {
        this.rootContainer.setWidget((Widget)new Label(error));
    }

    private TreeItem buildAssetTree(UICustomFieldAsset uiAsset) {
        TreeItem item = new TreeItem(uiAsset.getDisplayName());
        item.setUserObject((Object)uiAsset);
        if (uiAsset.getAssetList() != null && !uiAsset.getAssetList().isEmpty()) {
            this.addTreeChildren(uiAsset, item);
        }
        return item;
    }

    private void addSeriesTreeChildren(UICustomFieldAsset uiAsset, TreeItem item) {
        List<UICustomFieldAsset> assetList = uiAsset.getAssetList();
        for (UICustomFieldAsset asset : assetList) {
            String assetName = asset.getDisplayName();
            if (!assetName.equalsIgnoreCase("Season")) continue;
            TreeItem child = new TreeItem(asset.getDisplayName());
            if (child.isSelected()) {
                child.addStyleName(STYLE_TREEITEM_SELECTED);
            } else {
                child.removeStyleName(STYLE_TREEITEM_SELECTED);
            }
            item.addItem(child);
            child.setUserObject((Object)asset);
            if (asset.getAssetList() == null || asset.getAssetList().isEmpty()) continue;
            this.addSeriesTreeChildren(asset, child);
        }
    }

    private void addTreeChildren(UICustomFieldAsset uiAsset, TreeItem item) {
        List<UICustomFieldAsset> assetList = uiAsset.getAssetList();
        for (UICustomFieldAsset asset : assetList) {
            TreeItem child = new TreeItem(asset.getDisplayName());
            if (child.isSelected()) {
                child.addStyleName(STYLE_TREEITEM_SELECTED);
                child.setWidth("100%");
            } else {
                child.removeStyleName(STYLE_TREEITEM_SELECTED);
            }
            item.addItem(child);
            child.setUserObject((Object)asset);
            if (asset.getAssetList() == null || asset.getAssetList().isEmpty()) continue;
            this.addTreeChildren(asset, child);
        }
    }

    public void addGroupsModified(UICustomFieldGroup group) {
        if (this.groupsModified == null) {
            this.groupsModified = new ArrayList<UICustomFieldGroup>();
        }
        this.groupsModified.add(group);
    }

    public List<UICustomFieldGroup> getGroupsModified() {
        return this.groupsModified;
    }

    public void setGroupsModified(List<UICustomFieldGroup> groupsModified) {
        this.groupsModified = groupsModified;
    }

    public void saveGroups() {
        if (this.groupsModified != null && !this.groupsModified.isEmpty()) {
            this.viewService.saveGroups(this.groupsModified, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    CustomFieldTabView.this.messageContainer.setErrorMessage("Save error: " + caught.getMessage());
                }

                public void onNeptuneSuccess(Void result) {
                    CustomFieldTabView.this.messageContainer.setInfoMessage("Custom Field Groups were saved");
                    CustomFieldTabView.this.groupsModified = null;
                    CustomFieldTabView.this.initTree();
                }
            });
        }
    }

    public boolean saveAll() {
        this.showBusyIndicator();
        List<UICustomFieldGroup> groupList = this.getAllAssetGroups();
        if (!this.validateAll(groupList)) {
            this.hideBusyindicator();
            return false;
        }
        this.viewService.saveGroups(groupList, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof CustomFieldDeleteValidationException) {
                    CustomFieldTabView.this.messageContainer.setErrorMessage("Save error: " + caught.getMessage());
                    CustomFieldTabView.this.initTree();
                } else {
                    CustomFieldTabView.this.messageContainer.setErrorMessage("Save error: " + caught.getMessage());
                }
                CustomFieldTabView.this.hideBusyindicator();
            }

            public void onNeptuneSuccess(Void result) {
                CustomFieldTabView.this.messageContainer.setInfoMessage("Custom Field Groups were saved successfully.");
                CustomFieldTabView.this.initTree();
                CustomFieldTabView.this.hideBusyindicator();
            }
        });
        return true;
    }

    public boolean checkLatestGroups() {
        ArrayList<UICustomFieldGroup> currentList = new ArrayList();
        if (this.groupsView != null) {
            currentList = this.groupsView.getAssetDisplayed().getGroupList();
        }
        if (CustomFieldUtil.hasDuplicate(currentList)) {
            List duplicates = CustomFieldUtil.getDuplicate(currentList);
            String duplStr = CustomFieldUtil.getDuplicateMessage(duplicates);
            this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.groupDisplayNameAlreadyExists()) + " " + duplStr);
            return false;
        }
        if (!this.validateUniqueCustomFieldName(currentList)) {
            return false;
        }
        if (this.groupsModified == null) {
            this.groupsModified = new ArrayList<UICustomFieldGroup>();
        }
        for (UICustomFieldGroup group : currentList) {
            if (this.groupsModified.contains(group)) continue;
            this.groupsModified.add(group);
        }
        return true;
    }

    private boolean validateUniqueCustomFieldName(List<UICustomFieldGroup> currentList) {
        ArrayList<UICustomField> fieldList = new ArrayList<UICustomField>();
        if (currentList != null) {
            for (UICustomFieldGroup group : currentList) {
                List<UICustomField> list = group.getFieldList();
                if (list == null) continue;
                fieldList.addAll(list);
            }
        }
        this.resetList(fieldList);
        for (UICustomField field : fieldList) {
            if (field.getName() == null || !field.getName().equalsIgnoreCase("lookupkey") && !field.getName().equalsIgnoreCase("materialid") && !field.getName().equalsIgnoreCase("encodeformat") && !field.getName().equalsIgnoreCase("encodeprofile")) continue;
            this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.wrongCustomFieldValue()) + " " + field.getName() + " for Asset " + field.getAssetPath());
            return false;
        }
        if (CustomFieldUtil.hasDuplicate(fieldList)) {
            List duplicates = CustomFieldUtil.getDuplicate(fieldList);
            String duplString = CustomFieldUtil.getDuplicatesMessage(duplicates);
            this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.customFieldNameAlreadyExists()) + " " + duplString);
            return false;
        }
        for (UICustomField field : fieldList) {
            if (!field.isDuplFlag()) continue;
            this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.customFieldDiffAssetDiffDatatype()) + " " + " Asset : " + field.getAssetPath() + " Name: " + field.getName());
            return false;
        }
        return true;
    }

    private void resetList(List<UICustomField> fieldList) {
        for (UICustomField field : fieldList) {
            field.setDuplFlag(false);
        }
    }

    public boolean validate() {
        boolean token = true;
        this.messageContainer.reset();
        if (this.groupsModified != null && !this.groupsModified.isEmpty()) {
            for (UICustomFieldGroup group : this.groupsModified) {
                if (group.getDisplayName() == null || group.getDisplayName().trim().isEmpty()) {
                    this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldGroupDisplayName()) + ": " + group.getAssetPath());
                    token = false;
                }
                if (this.validateFields(group)) continue;
                token = false;
            }
        }
        return token;
    }

    private boolean validateFields(UICustomFieldGroup group) {
        boolean valid = true;
        List<UICustomField> fieldsList = group.getFieldList();
        if (fieldsList != null) {
            for (UICustomField field : fieldsList) {
                if (field.getName() == null || field.getName().trim().isEmpty()) {
                    if (fieldsList.indexOf(field) != -1 && fieldsList.indexOf(field) != fieldsList.size() - 1) {
                        this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldName()) + ": " + group.getAssetPath());
                        valid = false;
                    } else if (!field.getDataType().equals(CustomFieldDataType.STRING.toString()) || field.getFieldType() != 1 || field.isJobParameter() || field.isJobScheduleParameter()) {
                        this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldName()) + ": " + group.getAssetPath());
                        valid = false;
                    }
                } else if (this.validateSpecialChars(field.getName())) {
                    this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.specialCharsName()) + " Asset : " + field.getAssetPath() + " Name: " + field.getName());
                    valid = false;
                }
                if (field.getDisplayName() == null || field.getDisplayName().trim().isEmpty()) {
                    if (fieldsList.indexOf(field) != -1 && fieldsList.indexOf(field) != fieldsList.size() - 1) {
                        this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldDisplayName()) + ": " + group.getAssetPath());
                        valid = false;
                    } else if (!field.getDataType().equals(CustomFieldDataType.STRING.toString()) || field.getFieldType() != 1 || field.isJobParameter() || field.isJobScheduleParameter()) {
                        this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldDisplayName()) + ": " + group.getAssetPath());
                        valid = false;
                    }
                }
                if (field.getName() == null) continue;
                field.setName(field.getName().trim());
            }
        }
        return valid;
    }

    private boolean validateSpecialChars(String name) {
        String trimmedName = name.replace(" ", "");
        trimmedName.trim();
        return !trimmedName.matches("^[a-zA-Z0-9_-]*$");
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyindicator() {
        this.busyIndicator.hide();
    }

    public void refresh() {
    }

    public boolean hasErrors() {
        if (this.groupsModified != null && CustomFieldUtil.hasDuplicate(this.groupsModified)) {
            this.messageContainer.setErrorMessage(this.myConstants.groupDisplayNameAlreadyExists());
            return true;
        }
        return false;
    }

    public void clearAll() {
        this.messageContainer.reset();
        this.groupsModified = null;
        this.initTree();
    }

    public boolean validateAll(List<UICustomFieldGroup> groupList) {
        boolean status = true;
        if (CustomFieldUtil.hasDuplicate(groupList)) {
            List duplicates = CustomFieldUtil.getDuplicate(groupList);
            String duplStr = CustomFieldUtil.getDuplicateMessage(duplicates);
            this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.groupDisplayNameAlreadyExists()) + " " + duplStr);
            status = false;
        }
        if (!this.validateUniqueCustomFieldName(groupList)) {
            status = false;
        }
        for (UICustomFieldGroup group : groupList) {
            if (group.getDisplayName() == null || group.getDisplayName().trim().isEmpty()) {
                this.messageContainer.setErrorMessage(String.valueOf(this.myConstants.emptyCustomFieldGroupDisplayName()) + ": " + group.getAssetPath());
                status = false;
            }
            if (this.validateFields(group)) continue;
            status = false;
        }
        return status;
    }

    private List<UICustomFieldGroup> getAllAssetGroups() {
        ArrayList<UICustomFieldGroup> groupList = new ArrayList<UICustomFieldGroup>();
        if (this.tree != null) {
            int count = this.tree.getItemCount();
            int i = 0;
            while (i < count) {
                TreeItem item = this.tree.getItem(i);
                UICustomFieldAsset asset = (UICustomFieldAsset)item.getUserObject();
                if (asset.getGroupList() != null) {
                    groupList.addAll(asset.getGroupList());
                }
                this.traverse(item, groupList);
                ++i;
            }
        }
        return groupList;
    }

    public void traverse(TreeItem item, List<UICustomFieldGroup> groupList) {
        int i = 0;
        while (i < item.getChildCount()) {
            TreeItem child = item.getChild(i);
            UICustomFieldAsset asset = (UICustomFieldAsset)child.getUserObject();
            if (asset.getGroupList() != null) {
                groupList.addAll(asset.getGroupList());
            }
            this.traverse(child, groupList);
            ++i;
        }
    }

    public CustomFieldGroupsView getGroupsView() {
        return this.groupsView;
    }
}

