/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiAssetType;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeysListPanel;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.UiLookupKeyRecord;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class LookupKeyDetailView
implements DetailView<Long, UiLookupKeyRecord> {
    private static final String SHUFFLE_BOX = "asset-type-shuffle";
    private static final String LIST_BOX = "asset-type-shuffle-list-box";
    private static final String MOVE_RIGHT_BUTTON = "asset-type-shuffle-button";
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private final UiLookupKeyRecord record;
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private TextAreaWidget descriptionTextArea;
    private int DESCRIPTION_VISIBLE_COUNT = 5;
    private int DESCRIPTION_CHAR_WIDTH = 40;
    private HorizontalPanel shuffleBox;
    private SimpleListBoxWidget rightList;
    private SimpleListBoxWidget leftList;
    private final FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final VerticalContainer mainContainer = new VerticalContainer();
    private LookupKeysListPanel parentPanel;
    private DetailViewCallback<Long, UiLookupKeyRecord> callback;

    public LookupKeyDetailView(UiLookupKeyRecord record, DetailViewCallback<Long, UiLookupKeyRecord> callback, LookupKeysListPanel parentPanel) {
        this.record = record;
        this.nameTextBox.setText(record.getLookupKey().getName());
        this.formContainer.addRow(this.constants.lookupKeyNameColumn(), (Widget)this.nameTextBox, true);
        this.descriptionTextArea = new TextAreaWidget();
        this.descriptionTextArea.setCharacterWidth(this.DESCRIPTION_CHAR_WIDTH);
        this.descriptionTextArea.setVisibleLines(this.DESCRIPTION_VISIBLE_COUNT);
        this.descriptionTextArea.setText(record.getLookupKey().getDescription());
        this.formContainer.addRow(this.constants.lookupKeyDescriptionColumn(), (Widget)this.descriptionTextArea, true);
        this.shuffleBox = this.createShuffleBox();
        this.formContainer.addRow(this.constants.lookupKeyAssetTypesColumn(), (Widget)this.shuffleBox, false);
        this.parentPanel = parentPanel;
        this.callback = callback;
        this.updateWidgetsAccess();
    }

    public void save() {
        this.parentPanel.getResizableContainer().setErrorMessage(null);
        this.callback.save((DetailView)this);
    }

    public void cancel() {
        this.parentPanel.getResizableContainer().setErrorMessage(null);
        this.callback.cancel((DetailView)this);
    }

    private void updateWidgetsAccess() {
        boolean isCreating = this.record.getKey() == null;
        this.nameTextBox.setReadOnly(!isCreating);
        if (this.saveButtonIsVisible(isCreating)) {
            this.parentPanel.showSaveButton();
        } else {
            this.parentPanel.hideSaveButton();
        }
        this.parentPanel.showCancelButton();
        this.parentPanel.hideDeleteButton();
    }

    private boolean saveButtonIsVisible(boolean isCreating) {
        boolean visible;
        boolean bl = visible = !this.record.getLookupKey().isReadOnly();
        if (visible) {
            visible = isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Modify"});
        }
        return visible;
    }

    private HorizontalPanel createShuffleBox() {
        HorizontalPanel shufflePanel = new HorizontalPanel();
        shufflePanel.setStyleName(SHUFFLE_BOX);
        this.rightList = new SimpleListBoxWidget(true);
        this.rightList.setStyleName(LIST_BOX);
        this.leftList = new SimpleListBoxWidget(true);
        this.leftList.setStyleName(LIST_BOX);
        ButtonWidget moveRightButton = new ButtonWidget();
        moveRightButton.addStyleName(MOVE_RIGHT_BUTTON);
        moveRightButton.setText(">");
        moveRightButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = LookupKeyDetailView.this.leftList.getItemCount() - 1;
                while (index >= 0) {
                    if (LookupKeyDetailView.this.leftList.isItemSelected(index)) {
                        int selectedIndex = LookupKeyDetailView.this.leftList.getSelectedIndex();
                        String assetDisplayName = LookupKeyDetailView.this.leftList.getItemText(selectedIndex);
                        String assetName = LookupKeyDetailView.this.leftList.getValue(selectedIndex);
                        LookupKeyDetailView.this.leftList.removeItem(selectedIndex);
                        LookupKeyDetailView.this.rightList.addItem(assetDisplayName, assetName);
                    }
                    --index;
                }
            }
        });
        VerticalPanel leftListContainer = this.createListBoxContainer(this.constants.notAssociated());
        leftListContainer.add((Widget)this.leftList);
        VerticalPanel rightListContainer = this.createListBoxContainer(this.constants.associated());
        rightListContainer.add((Widget)this.rightList);
        shufflePanel.add((Widget)leftListContainer);
        shufflePanel.add((Widget)moveRightButton);
        shufflePanel.add((Widget)rightListContainer);
        shufflePanel.setCellVerticalAlignment((Widget)moveRightButton, HasVerticalAlignment.ALIGN_MIDDLE);
        shufflePanel.setSpacing(5);
        ILookupKeyServiceAsync lookupKeyService = (ILookupKeyServiceAsync)GWT.create(ILookupKeyService.class);
        lookupKeyService.getAllAssetTypes((AsyncCallback<List<UiAssetType>>)new NeptuneAsyncCallback<List<UiAssetType>>(){

            public void onNeptuneFailure(Throwable caught) {
                LookupKeyDetailView.this.parentPanel.getResizableContainer().setErrorMessage(LookupKeyDetailView.this.constants.retrieveAssetTypesFailure());
            }

            public void onNeptuneSuccess(List<UiAssetType> result) {
                for (UiAssetType uiAssetType : result) {
                    if (LookupKeyDetailView.this.recordContainsAssetType(uiAssetType.getName())) {
                        LookupKeyDetailView.this.rightList.addItem(uiAssetType.getDisplayName(), uiAssetType.getName());
                        continue;
                    }
                    LookupKeyDetailView.this.leftList.addItem(uiAssetType.getDisplayName(), uiAssetType.getName());
                }
            }
        });
        return shufflePanel;
    }

    private boolean recordContainsAssetType(String name) {
        boolean contains = false;
        for (UiAssetType uiAssetType : this.record.getLookupKey().getAssetTypes()) {
            if (!uiAssetType.getName().equalsIgnoreCase(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private VerticalPanel createListBoxContainer(String label) {
        VerticalPanel container = new VerticalPanel();
        container.add((Widget)new LabelWidget(label));
        return container;
    }

    public void commit() {
        this.record.getLookupKey().setName(this.nameTextBox.getText() == null ? null : this.nameTextBox.getText().trim());
        this.record.getLookupKey().setDescription(this.descriptionTextArea.getText() == null ? null : this.descriptionTextArea.getText().trim());
        this.record.getLookupKey().getAssetTypes().clear();
        int assetTypesCount = this.rightList.getItemCount();
        if (assetTypesCount > 0) {
            int x = 0;
            while (x < assetTypesCount) {
                String name = this.rightList.getValue(x);
                String displayName = this.rightList.getItemText(x);
                this.record.getLookupKey().getAssetTypes().add(new UiAssetType(name, displayName));
                ++x;
            }
        }
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void revert() {
        this.nameTextBox.setText(this.record.getLookupKey().getName());
        this.descriptionTextArea.setText(this.record.getLookupKey().getDescription());
        this.leftList.clear();
        this.rightList.clear();
        for (UiAssetType uiAssetType : this.record.getLookupKey().getAssetTypes()) {
            if (this.record.getLookupKey().getAssetTypes().contains(uiAssetType.getName())) {
                this.rightList.addItem(uiAssetType.getDisplayName(), uiAssetType.getName());
                continue;
            }
            this.leftList.addItem(uiAssetType.getDisplayName(), uiAssetType.getName());
        }
        this.updateWidgetsAccess();
    }

    public UiLookupKeyRecord getRecord() {
        return this.record;
    }

    public String getStyleName() {
        return null;
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            StringBuffer messagesSB = new StringBuffer("<ul>");
            for (String message : ve.getValidationMessages()) {
                messagesSB.append("<li>").append(message).append("</li>");
            }
            messagesSB.append("</ul>");
            this.parentPanel.getResizableContainer().setErrorHTML(messagesSB.toString());
        } else {
            this.parentPanel.getResizableContainer().setErrorMessage(throwable.getLocalizedMessage());
        }
    }

    public void release() {
    }
}

