/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LimitedLabelStringView;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.UiLookupKeyRecord;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LookupKeysDataProvider
implements DataProvider<Long, UiLookupKeyRecord> {
    private final List<Column<?, UiLookupKeyRecord>> columns;
    private final ColumnBase<String, UiLookupKeyRecord> nameColumn;
    private final ColumnBase<String, UiLookupKeyRecord> descriptionColumn;
    private final ColumnBase<String, UiLookupKeyRecord> assetTypesColumn;
    private int COLUMN_SIZE_LIMIT = 100;
    ILookupKeyServiceAsync lookupKeyService = (ILookupKeyServiceAsync)GWT.create(ILookupKeyService.class);
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private SortFeatureImpl<Long, UiLookupKeyRecord> parentSortFeature;
    private static String NAME_COLUMN = "name";
    private static String DESCRIPTION_COLUMN = "description";
    private static String ASSET_TYPES_COLUMN = "assetTypes";
    private IBusyNotifier busyNotifier;

    public LookupKeysDataProvider() {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiLookupKeyRecord>(NAME_COLUMN, this.constants.lookupKeyNameColumn()){

            public View<String> getView(UiLookupKeyRecord record) {
                return new LabelStringView(record.getLookupKey().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLookupKeyRecord>)this.nameColumn);
        this.descriptionColumn = new ColumnBase<String, UiLookupKeyRecord>(DESCRIPTION_COLUMN, this.constants.lookupKeyDescriptionColumn()){

            public View<String> getView(UiLookupKeyRecord record) {
                return new LimitedLabelStringView(record.getLookupKey().getDescription(), LookupKeysDataProvider.this.COLUMN_SIZE_LIMIT);
            }
        };
        this.descriptionColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLookupKeyRecord>)this.descriptionColumn);
        this.assetTypesColumn = new ColumnBase<String, UiLookupKeyRecord>(ASSET_TYPES_COLUMN, this.constants.lookupKeyAssetTypesColumn()){

            public View<String> getView(UiLookupKeyRecord record) {
                return new LimitedLabelStringView(record.getLookupKey().getAssetTypesAsString(), LookupKeysDataProvider.this.COLUMN_SIZE_LIMIT);
            }
        };
        this.assetTypesColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLookupKeyRecord>)this.assetTypesColumn);
    }

    public ColumnBase<String, UiLookupKeyRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiLookupKeyRecord>> getSortColumns() {
        ArrayList sortColumns = new ArrayList();
        sortColumns.add((Column<?, UiLookupKeyRecord>)this.nameColumn);
        sortColumns.add((Column<?, UiLookupKeyRecord>)this.descriptionColumn);
        return sortColumns;
    }

    public List<Column<?, UiLookupKeyRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiLookupKeyRecord> callback) {
        this.notifyBusyStart();
        this.lookupKeyService.get(key, (AsyncCallback<UiLookupKey>)new NeptuneAsyncCallback<UiLookupKey>(){

            public void onNeptuneFailure(Throwable caught) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiLookupKey result) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onSuccess((Object)new UiLookupKeyRecord(result));
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiLookupKeyRecord>> callback) {
        this.notifyBusyStart();
        this.lookupKeyService.getLookupKeys(this.parentSortFeature.getSortColumnName(), this.parentSortFeature.isAscending(), (AsyncCallback<List<UiLookupKey>>)new NeptuneAsyncCallback<List<UiLookupKey>>(){

            public void onNeptuneFailure(Throwable caught) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiLookupKey> result) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onSuccess(this.prepareUIObjects(result));
            }

            private List<UiLookupKeyRecord> prepareUIObjects(List<UiLookupKey> result) {
                ArrayList<UiLookupKeyRecord> records = new ArrayList<UiLookupKeyRecord>();
                for (UiLookupKey list : result) {
                    records.add(new UiLookupKeyRecord(list));
                }
                return records;
            }
        });
    }

    public void deleteRecords(List<Long> lookupKeyIds, final AsyncCallback<Map<Long, Boolean>> callback) {
        this.notifyBusyStart();
        this.lookupKeyService.delete(lookupKeyIds, (AsyncCallback<Map<Long, Boolean>>)new NeptuneAsyncCallback<Map<Long, Boolean>>(){

            public void onNeptuneFailure(Throwable caught) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Map<Long, Boolean> result) {
                LookupKeysDataProvider.this.notifyBusyFinish();
                callback.onSuccess(result);
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public SortFeatureImpl<Long, UiLookupKeyRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiLookupKeyRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

