/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.lookupkey.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeyAnchorChangeListener;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeyDetailFeature;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeysDataProvider;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.UiLookupKeyRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LookupKeysListPanel
extends Composite
implements IView {
    private LookupKeysDataProvider dataProvider;
    private SortFeatureImpl<Long, UiLookupKeyRecord> sortFeature;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private LookupKeyDetailFeature detailFeature;
    private VerticalContainer mainContainer;
    private Table<Long, UiLookupKeyRecord> table;
    private ListBoxWidget<String> parameterListBox;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private ResizableContainer resizableContainer;
    private static final String STYLE_NAME = "content-LookupKeysPanel";
    private static final String CONTENT_LOOKUP_KEY_VIEW_INFO = "content-LookupKeyViewInfo";
    private static final String CONTENT_LOOKUP_KEYS_TABLE = "content-LookupKeysTable";
    private ButtonWidget btnCreate;
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private ButtonWidget deleteButton;
    private MessageArea infoMessageArea;
    private Long DEFAULT = 1L;
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);

    public LookupKeysListPanel() {
        this.dataProvider = new LookupKeysDataProvider();
        this.dataProvider.setBusyNotifier(new LookupKeysDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                LookupKeysListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                LookupKeysListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.infoMessageArea);
        this.resizableContainer.addButton(this.constants.lookupKeyTabHeading(), this.btnCreate);
        this.resizableContainer.addButton(this.constants.lookupKeyTabHeading(), this.saveButton);
        this.resizableContainer.addButton(this.constants.lookupKeyTabHeading(), this.cancelButton);
        this.resizableContainer.addButton(this.constants.lookupKeyTabHeading(), this.deleteButton);
        this.mainContainer.add((Widget)this.resizableContainer);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.infoMessageArea = new MessageArea();
        this.infoMessageArea.setStyleName(CONTENT_LOOKUP_KEY_VIEW_INFO);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addStyleName(CONTENT_LOOKUP_KEYS_TABLE);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiLookupKeyRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiLookupKeyRecord> event) {
                LookupKeysListPanel.this.hideCreateButton();
                if (event.isCreateView()) {
                    LookupKeysListPanel.this.header.setLabel(LookupKeysListPanel.this.constants.lookupKeyCreateHeading());
                } else {
                    LookupKeysListPanel.this.header.setLabel(String.valueOf(LookupKeysListPanel.this.constants.lookupKeyViewEditHeading()) + " " + ((UiLookupKeyRecord)event.getRecord()).getLookupKey().getName());
                }
            }

            public void onShowListView(TableViewEvent event) {
                LookupKeysListPanel.this.showCreateButton();
                LookupKeysListPanel.this.hideSaveButton();
                LookupKeysListPanel.this.hideCancelButton();
                LookupKeysListPanel.this.showDeleteButton();
                LookupKeysListPanel.this.header.setLabel(LookupKeysListPanel.this.constants.lookupKeyListHeading());
                LookupKeysListPanel.this.header.setStyleName("content-header-style");
            }
        });
        this.table.addRefreshListener(new Table.RefreshListener(){

            public void updated() {
                LookupKeysListPanel.this.hideDefaultCheckBox();
            }
        });
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiLookupKeyRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.detailFeature = new LookupKeyDetailFeature(this);
        this.table.addSortFeature(this.sortFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.resizableContainer = new ResizableContainer(this.table, this.constants.lookupKeyTabHeading(), null);
        this.resizableContainer.getMessageArea().setStyleName(CONTENT_LOOKUP_KEY_VIEW_INFO);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.btnCreate = new ButtonWidget(this.constants.createButton());
        this.btnCreate.removeStyleName("gwt-Button");
        this.btnCreate.addStyleName("ebBtn");
        this.btnCreate.addStyleName("ebBtn_color_green");
        this.btnCreate.addStyleName("create_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Create"})) {
            this.btnCreate.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    LookupKeysListPanel.this.table.showCreateView();
                }
            });
        }
        this.btnCreate.setVisible(false);
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LookupKeysListPanel.this.detailFeature.getDetailView().save();
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.setVisible(false);
        this.cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LookupKeysListPanel.this.detailFeature.getDetailView().cancel();
            }
        });
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.setVisible(false);
        this.deleteButton = new ButtonWidget(this.constants.delButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LookupKeysListPanel.this.deleteIds();
            }
        });
        this.deleteButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.deleteButton.addStyleName("delete_button_icon");
        this.deleteButton.setVisible(false);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new LookupKeyAnchorChangeListener(this);
        this.infoMessageArea.reset();
    }

    protected void showCreateButton() {
        this.btnCreate.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Create"}));
    }

    private void showDeleteButton() {
        this.deleteButton.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_Delete"}));
    }

    protected void hideCreateButton() {
        this.btnCreate.setVisible(false);
    }

    public void showSaveButton() {
        this.saveButton.setVisible(true);
    }

    public void hideSaveButton() {
        this.saveButton.setVisible(false);
    }

    public void showCancelButton() {
        this.cancelButton.setVisible(true);
    }

    public void hideCancelButton() {
        this.cancelButton.setVisible(false);
    }

    public void hideDeleteButton() {
        this.deleteButton.setVisible(false);
    }

    Table<Long, UiLookupKeyRecord> getLookupKeysTable() {
        return this.table;
    }

    public void reportFailure(Throwable caught) {
        this.getResizableContainer().setErrorMessage(caught.getMessage());
        this.getResizableContainer().setInfoMessage(null);
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void cleanup() {
        this.getResizableContainer().setErrorMessage(null);
        this.infoMessageArea.reset();
    }

    public IActionInput getInputToExecution() {
        return null;
    }

    public Widget getParentContainer() {
        return this.mainContainer;
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.table.getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UiLookupKeyRecord tr : selectedIds) {
            ids.add(tr.getKey());
        }
        ids.remove(this.DEFAULT);
        return ids;
    }

    public void refresh(String infoMessage) {
        this.mainContainer.clear();
        this.setContainers();
        this.table.getPageFeature().setPageNumber(1);
        this.table.showListView();
        this.table.refresh();
        this.table.updateAnchor();
        this.show(infoMessage);
    }

    public void show(String infoMessage) {
        if (infoMessage != null && !infoMessage.isEmpty()) {
            this.getResizableContainer().setInfoMessage(infoMessage);
        }
    }

    public void show(boolean readOnly) {
        this.parameterListBox.setEnabled(readOnly);
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public ResizableContainer getResizableContainer() {
        return this.resizableContainer;
    }

    private void deleteIds() {
        this.resetMessages();
        List ids = this.table.getSelectedRecords();
        if (ids.size() > 0) {
            String msg = "Are you sure you want to delete?";
            if (Window.confirm((String)msg)) {
                try {
                    this.deleteLookupKeys(ids);
                }
                catch (Exception e) {
                    this.setErrorMessage(e.getMessage());
                }
            }
        } else {
            this.setErrorMessage(this.messages.lookupKeySelectMessage());
        }
    }

    private void resetMessages() {
        this.infoMessageArea.reset();
        this.getResizableContainer().getMessageArea().reset();
    }

    private void deleteLookupKeys(List<UiLookupKeyRecord> ids) throws Exception {
        if (ids.size() > 0) {
            ArrayList<Long> lookupKeyIds = new ArrayList<Long>();
            final HashMap<Long, String> lookupKeysMap = new HashMap<Long, String>();
            for (UiLookupKeyRecord uid : ids) {
                if (uid.getKey() == this.DEFAULT) continue;
                lookupKeyIds.add(uid.getKey());
                lookupKeysMap.put(uid.getKey(), uid.getLookupKey().getName());
            }
            if (lookupKeyIds.contains(new Long(1L))) {
                throw new Exception("Default LookupKey can't be deleted.");
            }
            this.dataProvider.deleteRecords(lookupKeyIds, (AsyncCallback<Map<Long, Boolean>>)new NeptuneAsyncCallback<Map<Long, Boolean>>(){

                public void onNeptuneFailure(Throwable caught) {
                    LookupKeysListPanel.this.setErrorMessage("Error Deleting LookupKey :" + caught.toString());
                }

                public void onNeptuneSuccess(Map<Long, Boolean> result) {
                    ArrayList<String> deleted = new ArrayList<String>();
                    ArrayList<String> skipped = new ArrayList<String>();
                    for (Map.Entry<Long, Boolean> e : result.entrySet()) {
                        if (e.getValue().booleanValue()) {
                            deleted.add((String)lookupKeysMap.get(e.getKey()));
                            continue;
                        }
                        skipped.add((String)lookupKeysMap.get(e.getKey()));
                    }
                    LookupKeysListPanel.this.refreshDataProvider();
                    if (deleted.size() > 0) {
                        StringBuilder infomsg = new StringBuilder();
                        infomsg.append(LookupKeysListPanel.this.messages.lookupKeyDeleteSuccess(((Object)deleted).toString()));
                        LookupKeysListPanel.this.setInfoMessage(infomsg.toString());
                    }
                    if (skipped.size() > 0) {
                        StringBuilder errmsg = new StringBuilder();
                        errmsg.append(LookupKeysListPanel.this.messages.lookupKeyDeleteFailed(((Object)skipped).toString()));
                        LookupKeysListPanel.this.setErrorMessage(errmsg.toString());
                    }
                }
            });
        }
    }

    public void refreshDataProvider() {
        this.dataProvider.getRecords((AsyncCallback<List<UiLookupKeyRecord>>)new NeptuneAsyncCallback<List<UiLookupKeyRecord>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiLookupKeyRecord> result) {
                LookupKeysListPanel.this.table.refresh();
            }
        });
    }

    protected void setErrorMessage(String errMsg) {
        if (errMsg != null && !errMsg.isEmpty()) {
            this.getResizableContainer().setErrorMessage(errMsg);
        }
    }

    protected void setInfoMessage(String infoMsg) {
        if (infoMsg != null && !infoMsg.isEmpty()) {
            this.infoMessageArea.setInfoMessage(infoMsg);
        }
    }

    protected void hideDefaultCheckBox() {
        List lst = this.table.getDataRowsCheckBoxes();
        for (CheckBox chk : lst) {
            if (((UiLookupKeyRecord)chk.getRecord()).getKey() != this.DEFAULT) continue;
            chk.setVisible(false);
        }
    }
}

