/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.AppTypeConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.ContentAdvisoryConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.GenreConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.ProductConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.RatingConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.StudioConfigTab;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MetadataConfigLazyView
extends LazyView {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private VerticalPanel verticalPanel;
    private HeaderPanel headerPanel;
    private BusyIndicator busyIndicator;
    private static int APPTYPE_TAB_INDEX = 0;
    private static final String METADATA_CONFIG_PANEL_STYLE = "content-metadataConfig-panel";
    private static final String METADATA_CONFIG_HEADER_LABEL_STYLE = "content-metadataConfigHeaderWidget-headingLabel";
    public static final String TAB_ANCHOR_KEY = "Tab";
    private int selectedTab = APPTYPE_TAB_INDEX;
    private ResizableContainer resizableTabContainer;
    private List<MetadataConfigTab> tabs;
    private ButtonWidget btnCreate;
    private ButtonWidget btnDelete;
    private ButtonWidget btnSave;
    private ButtonWidget btnCancel;

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public String getAnchor() {
        AnchorTokenizer tokenizer = new AnchorTokenizer();
        LinkedHashMap<String, String> anchorTokens = new LinkedHashMap<String, String>();
        anchorTokens.put(TAB_ANCHOR_KEY, this.getSelectedTabName());
        return tokenizer.buildAnchor(anchorTokens);
    }

    protected void setWidgetAnchor(String anchor) {
        AnchorTokenizer tokenizer = new AnchorTokenizer();
        Map anchorTokens = tokenizer.parseAnchor(anchor);
        String selectedTab = (String)anchorTokens.get(TAB_ANCHOR_KEY);
        if (selectedTab == null) {
            selectedTab = this.tabs.get(0).getTabName();
        }
        selectedTab = selectedTab.trim();
        this.showTab(selectedTab);
    }

    protected Widget createWidget() {
        this.busyIndicator = new BusyIndicator();
        this.verticalPanel = new VerticalPanel();
        this.verticalPanel.addStyleName(METADATA_CONFIG_PANEL_STYLE);
        this.headerPanel = new HeaderPanel(this.myConstants.metadataConfigHeaderLabel());
        this.headerPanel.addStyleName(METADATA_CONFIG_HEADER_LABEL_STYLE);
        this.headerPanel.getLabel().setStyleName("content-header-style");
        this.verticalPanel.add((Widget)this.headerPanel);
        this.tabs = new ArrayList<MetadataConfigTab>();
        this.btnCreate = new ButtonWidget(this.myConstants.create());
        this.btnCreate.removeStyleName("gwt-Button");
        this.btnCreate.addStyleName("ebBtn");
        this.btnCreate.addStyleName("ebBtn_color_green");
        this.btnCreate.addStyleName("create_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            this.btnCreate.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataConfigLazyView.this.clearErrors();
                    MetadataConfigTab tab = (MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab));
                    tab.showCreatePanel();
                }
            });
        }
        this.btnCreate.setVisible(false);
        this.btnDelete = new ButtonWidget(this.myConstants.delete());
        this.btnDelete.removeStyleName("gwt-Button");
        this.btnDelete.addStyleName("ebBtn");
        this.btnDelete.addStyleName("delete_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_View", "MetadataConfiguration_Delete"})) {
            this.btnDelete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataConfigLazyView.this.clearErrors();
                    MetadataConfigTab tab = (MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab));
                    tab.deleteSelected();
                }
            });
        }
        this.btnDelete.setVisible(false);
        this.btnSave = new ButtonWidget(this.myConstants.save());
        this.btnSave.removeStyleName("gwt-Button");
        this.btnSave.addStyleName("ebBtn");
        this.btnSave.addStyleName("ebBtn_color_green");
        this.btnSave.addStyleName("save_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            this.btnSave.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataConfigLazyView.this.clearErrors();
                    MetadataConfigTab tab = (MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab));
                    tab.save();
                }
            });
        }
        this.btnSave.setVisible(false);
        this.btnCancel = new ButtonWidget(this.myConstants.cancel());
        this.btnCancel.removeStyleName("gwt-Button");
        this.btnCancel.addStyleName("ebBtn");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            this.btnCancel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataConfigLazyView.this.clearErrors();
                    MetadataConfigTab tab = (MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab));
                    tab.getTable().refresh();
                    tab.showListPanel();
                }
            });
        }
        this.btnCancel.setVisible(false);
        this.addTab(new AppTypeConfigTab(this), this.myConstants.appTypeTabName());
        this.addTab(new ContentAdvisoryConfigTab(this), this.myConstants.contentAdvisoryTabName());
        this.addTab(new GenreConfigTab(this), this.myConstants.genreTabName());
        this.addTab(new ProductConfigTab(this), this.myConstants.productTabName());
        this.addTab(new RatingConfigTab(this), this.myConstants.ratingTabName());
        this.addTab(new StudioConfigTab(this), this.myConstants.studioTabName());
        this.resizableTabContainer.addHeightOffsettingWidget((Widget)this.headerPanel);
        MetadataConfigTabEventHandler handler = new MetadataConfigTabEventHandler();
        this.resizableTabContainer.addSelectionHandler((SelectionHandler)handler);
        this.resizableTabContainer.selectTab(this.myConstants.appTypeTabName());
        this.verticalPanel.add((Widget)this.resizableTabContainer);
        return this.verticalPanel;
    }

    protected void addTab(MetadataConfigTab tab, String tabname) {
        if (this.resizableTabContainer == null) {
            this.resizableTabContainer = new ResizableContainer((Widget)tab, tabname, null);
        } else {
            this.resizableTabContainer.addTab((Widget)tab, tabname);
        }
        tab.setTabName(tabname);
        this.tabs.add(tab);
    }

    private int getSelectedTabIndex() {
        return this.selectedTab;
    }

    private String getSelectedTabName() {
        int index = this.getSelectedTabIndex();
        Widget widget = (Widget)this.tabs.get(index);
        String tabName = null;
        if (widget instanceof MetadataConfigTab) {
            tabName = ((MetadataConfigTab)widget).getTabName();
        }
        return tabName;
    }

    private void updateTab(int tabIndex) {
        Widget widget = (Widget)this.tabs.get(tabIndex);
        if (widget instanceof MetadataConfigTab) {
            MetadataConfigTab tab = (MetadataConfigTab)widget;
            tab.refresh();
        }
    }

    private void showTab(String tabName) {
        MetadataConfigTab tab = this.getTab(tabName);
        this.resizableTabContainer.selectTab(tabName);
        tab.refresh();
    }

    public MetadataConfigTab getTab(String tabName) {
        for (MetadataConfigTab tab : this.tabs) {
            if (!tab.getTabName().equals(tabName)) continue;
            return tab;
        }
        return null;
    }

    protected void fireViewAnchorChange() {
        String anchor = this.getAnchor();
        this.fireEvent((GwtEvent)new ViewAnchorChangeEvent(anchor));
    }

    public void setError(String message) {
        this.resizableTabContainer.getMessageArea().setErrorMessage(message);
        this.resizableTabContainer.updateSize();
    }

    public void setWarning(String warning) {
        this.resizableTabContainer.getMessageArea().setInfoMessage(warning);
        this.resizableTabContainer.updateSize();
    }

    public void showListViewButtons() {
        this.btnCreate.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"}));
        this.btnDelete.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_View", "MetadataConfiguration_Delete"}));
        this.btnCancel.setVisible(false);
        this.btnSave.setVisible(false);
    }

    public void showManageViewButtons() {
        this.btnCreate.setVisible(false);
        this.btnDelete.setVisible(false);
        this.btnCancel.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"}));
        this.btnSave.setVisible(ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"}));
    }

    public void clearErrors() {
        this.resizableTabContainer.setErrorMessage(null);
        this.resizableTabContainer.setInfoMessage(null);
    }

    private class MetadataConfigTabEventHandler
    implements SelectionHandler<Integer> {
        private MetadataConfigTabEventHandler() {
        }

        public void onSelection(SelectionEvent<Integer> event) {
            MetadataConfigLazyView.this.selectedTab = (Integer)event.getSelectedItem();
            MetadataConfigLazyView.this.fireViewAnchorChange();
            MetadataConfigLazyView.this.resizableTabContainer.addButton(((MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab))).getTabName(), MetadataConfigLazyView.this.btnCreate);
            MetadataConfigLazyView.this.resizableTabContainer.addButton(((MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab))).getTabName(), MetadataConfigLazyView.this.btnDelete);
            MetadataConfigLazyView.this.resizableTabContainer.addButton(((MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab))).getTabName(), MetadataConfigLazyView.this.btnSave);
            MetadataConfigLazyView.this.resizableTabContainer.addButton(((MetadataConfigTab)((Object)MetadataConfigLazyView.this.tabs.get(MetadataConfigLazyView.this.selectedTab))).getTabName(), MetadataConfigLazyView.this.btnCancel);
            MetadataConfigLazyView.this.updateTab((Integer)event.getSelectedItem());
        }
    }
}

