/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.UiAppTypeRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class AppTypeConfigController
implements IMetadataConfigController<UiAppType> {
    private UiAppTypeConfigServiceAsync service = (UiAppTypeConfigServiceAsync)GWT.create(UiAppTypeConfigService.class);
    private MetadataConfigTab<UiAppType, String, UiAppTypeRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public AppTypeConfigController(MetadataConfigTab<UiAppType, String, UiAppTypeRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        this.service.deleteAppType(itemIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
                AppTypeConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    AppTypeConfigController.this.tab.setError(AppTypeConfigController.this.myConstants.deleteFailed());
                    return;
                }
                AppTypeConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(AppTypeConfigController.this.myConstants.appTypeTabName(), AppTypeConfigController.this.tab.getCommaSeparatedList(itemIds)));
                AppTypeConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 1) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getAppType(ids[0], (AsyncCallback<UiAppType>)new NeptuneAsyncCallback<UiAppType>(){

            public void onNeptuneFailure(Throwable caught) {
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiAppType result) {
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiAppType item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateAppType(item, (AsyncCallback<UiAppType>)new NeptuneAsyncCallback<UiAppType>(){

            public void onNeptuneFailure(Throwable caught) {
                AppTypeConfigController.this.tab.setError(caught.getMessage());
                AppTypeConfigController.this.tab.refreshCreateView(item);
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiAppType result) {
                AppTypeConfigController.this.tab.refreshCreateView(null);
                AppTypeConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(AppTypeConfigController.this.myConstants.appTypeTabName(), item.getAppType()));
                AppTypeConfigController.this.tab.getView().hideBusyIndicator();
                AppTypeConfigController.this.getList();
                AppTypeConfigController.this.tab.showListPanel();
            }
        });
    }
}

