/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.AppTypeConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.AppTypeDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.UiAppTypeRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class AppTypeConfigTab
extends MetadataConfigTab<UiAppType, String, UiAppTypeRecord> {
    private boolean createViewInitialized = false;
    private TextBox appTypeTxt = null;
    private TextArea notesTxt = null;

    public AppTypeConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new AppTypeConfigController(this);
    }

    @Override
    public void refreshCreateView(UiAppType item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.appTypeTxt = new TextBox();
                this.appTypeTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.atColumnHeadingAppType()), (Widget)this.appTypeTxt, true);
                this.notesTxt = new TextArea();
                this.notesTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.atColumnHeadingNotes()), (Widget)this.notesTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.appTypeTxt.setText("");
                this.notesTxt.setText("");
            } else {
                this.appTypeTxt.setText(item.getAppType() == null ? "" : item.getAppType());
                this.notesTxt.setText(item.getNotes() == null ? "" : item.getNotes());
            }
        }
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiAppType appType = new UiAppType();
            appType.setAppType(this.appTypeTxt.getText().trim());
            appType.setNotes(this.notesTxt.getText().trim());
            this.controller.update(appType);
        }
    }

    @Override
    protected Table<String, UiAppTypeRecord> createTable() {
        AppTypeDataProvider dataProvider = new AppTypeDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiAppTypeRecord>)tbl);
        List<Column<?, UiAppTypeRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiAppTypeRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiAppTypeRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String appType = this.appTypeTxt.getText();
        if (this.isBlank(appType)) {
            return this.constants.errBlankAppType();
        }
        if (appType.trim().length() > 64) {
            return this.constants.errAppTypeTooLong();
        }
        String notes = this.notesTxt.getText();
        if (!this.isBlank(notes) && notes.trim().length() > 255) {
            return this.constants.errNoteTooLong();
        }
        return "";
    }
}

