/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiAppType;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiAppTypeConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.AppTypeConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.apptype.UiAppTypeRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

class AppTypeDataProvider
implements DataProvider<String, UiAppTypeRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiAppTypeConfigServiceAsync service = (UiAppTypeConfigServiceAsync)GWT.create(UiAppTypeConfigService.class);
    private Table<String, UiAppTypeRecord> table;
    private List<Column<?, UiAppTypeRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private AppTypeConfigTab tab;

    public AppTypeDataProvider(MetadataConfigLazyView view, AppTypeConfigTab tab) {
        this.view = view;
        this.tab = tab;
    }

    public List<Column<?, UiAppTypeRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiAppTypeRecord>)new ColumnBase<UiAppTypeRecord, UiAppTypeRecord>("APP_TYPE", this.myConstants.atColumnHeadingAppType()){

            public View<UiAppTypeRecord> getView(final UiAppTypeRecord record) {
                return new View<UiAppTypeRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getAppTypeDisplay());
                        label.setTitle(record.getAppType().getAppType());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiAppTypeRecord>)new ColumnBase<UiAppTypeRecord, UiAppTypeRecord>("NOTES", this.myConstants.atColumnHeadingNotes()){

            public View<UiAppTypeRecord> getView(final UiAppTypeRecord record) {
                return new View<UiAppTypeRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getNotesDisplay());
                        label.setTitle(record.getAppType().getNotes());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiAppTypeRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiAppTypeRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllAppTypes(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiAppType>>)new NeptuneAsyncCallback<List<UiAppType>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (AppTypeDataProvider.this.tab != null) {
                    AppTypeDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                AppTypeDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiAppType> result) {
                callback.onSuccess((Object)AppTypeDataProvider.this.convertRecords(result));
                AppTypeDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiAppTypeRecord> convertRecords(List<UiAppType> results) {
        ArrayList<UiAppTypeRecord> retVal = new ArrayList<UiAppTypeRecord>();
        for (UiAppType item : results) {
            retVal.add(new UiAppTypeRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiAppTypeRecord> table) {
        this.table = table;
    }
}

