/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.UiContentAdvisoryRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class ContentAdvisoryConfigController
implements IMetadataConfigController<UiContentAdvisory> {
    private UiContentAdvisoryConfigServiceAsync service = (UiContentAdvisoryConfigServiceAsync)GWT.create(UiContentAdvisoryConfigService.class);
    private MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public ContentAdvisoryConfigController(MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        this.service.deleteContentAdvsory(itemIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
                ContentAdvisoryConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    ContentAdvisoryConfigController.this.tab.setError(ContentAdvisoryConfigController.this.myConstants.deleteFailed());
                    return;
                }
                ContentAdvisoryConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(ContentAdvisoryConfigController.this.myConstants.contentAdvisoryTabName(), ContentAdvisoryConfigController.this.tab.getCommaSeparatedList(itemIds)));
                ContentAdvisoryConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 1) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getContentAdvisory(ids[0], (AsyncCallback<UiContentAdvisory>)new NeptuneAsyncCallback<UiContentAdvisory>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiContentAdvisory result) {
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiContentAdvisory item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateContentAdvisory(item, (AsyncCallback<UiContentAdvisory>)new NeptuneAsyncCallback<UiContentAdvisory>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentAdvisoryConfigController.this.tab.setError(caught.getMessage());
                ContentAdvisoryConfigController.this.tab.refreshCreateView(item);
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiContentAdvisory result) {
                ContentAdvisoryConfigController.this.tab.refreshCreateView(null);
                ContentAdvisoryConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(ContentAdvisoryConfigController.this.myConstants.contentAdvisoryTabName(), item.getContentAdvisory()));
                ContentAdvisoryConfigController.this.tab.getView().hideBusyIndicator();
                ContentAdvisoryConfigController.this.getList();
                ContentAdvisoryConfigController.this.tab.showListPanel();
            }
        });
    }
}

