/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.ContentAdvisoryConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.ContentAdvisoryDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.UiContentAdvisoryRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class ContentAdvisoryConfigTab
extends MetadataConfigTab<UiContentAdvisory, String, UiContentAdvisoryRecord> {
    private boolean createViewInitialized = false;
    private TextBox advisoryTxt = null;
    private TextArea descriptionTxt = null;

    public ContentAdvisoryConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new ContentAdvisoryConfigController(this);
    }

    @Override
    public void refreshCreateView(UiContentAdvisory item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.advisoryTxt = new TextBox();
                this.advisoryTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.caColumnHeadingContentAdvisory()), (Widget)this.advisoryTxt, true);
                this.descriptionTxt = new TextArea();
                this.descriptionTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.caColumnHeadingDescription()), (Widget)this.descriptionTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.advisoryTxt.setText("");
                this.descriptionTxt.setText("");
            } else {
                this.advisoryTxt.setText(item.getContentAdvisory() == null ? "" : item.getContentAdvisory());
                this.descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
            }
        }
    }

    @Override
    protected Table<String, UiContentAdvisoryRecord> createTable() {
        ContentAdvisoryDataProvider dataProvider = new ContentAdvisoryDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiContentAdvisoryRecord>)tbl);
        List<Column<?, UiContentAdvisoryRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiContentAdvisoryRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiContentAdvisoryRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String advisory = this.advisoryTxt.getText();
        if (this.isBlank(advisory)) {
            return this.constants.errBlankAdvisory();
        }
        if (advisory.trim().length() > 64) {
            return this.constants.errAdvisoryTooLong();
        }
        String description = this.descriptionTxt.getText();
        if (!this.isBlank(description) && description.trim().length() > 255) {
            return this.constants.errDescriptionTooLong();
        }
        return "";
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiContentAdvisory ca = new UiContentAdvisory();
            ca.setContentAdvisory(this.advisoryTxt.getText().trim());
            ca.setDescription(this.descriptionTxt.getText().trim());
            this.controller.update(ca);
        }
    }
}

