/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.ContentAdvisoryConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory.UiContentAdvisoryRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

public class ContentAdvisoryDataProvider
implements DataProvider<String, UiContentAdvisoryRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiContentAdvisoryConfigServiceAsync service = (UiContentAdvisoryConfigServiceAsync)GWT.create(UiContentAdvisoryConfigService.class);
    private Table<String, UiContentAdvisoryRecord> table;
    private List<Column<?, UiContentAdvisoryRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private ContentAdvisoryConfigTab tab;

    public ContentAdvisoryDataProvider(MetadataConfigLazyView view, ContentAdvisoryConfigTab tab) {
        this.tab = tab;
        this.view = view;
    }

    public List<Column<?, UiContentAdvisoryRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiContentAdvisoryRecord>)new ColumnBase<UiContentAdvisoryRecord, UiContentAdvisoryRecord>("ADVISORY", this.myConstants.caColumnHeadingContentAdvisory()){

            public View<UiContentAdvisoryRecord> getView(final UiContentAdvisoryRecord record) {
                return new View<UiContentAdvisoryRecord>(){

                    public void release() {
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getContentAdvisoryDisplay());
                        label.setTitle(record.getContentAdvisory().getContentAdvisory());
                        return label;
                    }

                    public String getStyleName() {
                        return null;
                    }
                };
            }
        });
        this.columns.add((Column<?, UiContentAdvisoryRecord>)new ColumnBase<UiContentAdvisoryRecord, UiContentAdvisoryRecord>("DESCRIPTION", this.myConstants.caColumnHeadingDescription()){

            public View<UiContentAdvisoryRecord> getView(final UiContentAdvisoryRecord record) {
                return new View<UiContentAdvisoryRecord>(){

                    public void release() {
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
                        label.setTitle(record.getContentAdvisory().getDescription());
                        return label;
                    }

                    public String getStyleName() {
                        return null;
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiContentAdvisoryRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiContentAdvisoryRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllContentAdvisories(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiContentAdvisory>>)new NeptuneAsyncCallback<List<UiContentAdvisory>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (ContentAdvisoryDataProvider.this.tab != null) {
                    ContentAdvisoryDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                ContentAdvisoryDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiContentAdvisory> result) {
                callback.onSuccess((Object)ContentAdvisoryDataProvider.this.convertRecords(result));
                ContentAdvisoryDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiContentAdvisoryRecord> convertRecords(List<UiContentAdvisory> results) {
        ArrayList<UiContentAdvisoryRecord> retVal = new ArrayList<UiContentAdvisoryRecord>();
        for (UiContentAdvisory item : results) {
            retVal.add(new UiContentAdvisoryRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiContentAdvisoryRecord> table) {
        this.table = table;
    }
}

