/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.UiGenreRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class GenreConfigController
implements IMetadataConfigController<UiGenre> {
    private UiGenreConfigServiceAsync service = (UiGenreConfigServiceAsync)GWT.create(UiGenreConfigService.class);
    private MetadataConfigTab<UiGenre, String, UiGenreRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public GenreConfigController(MetadataConfigTab<UiGenre, String, UiGenreRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        this.service.deleteGenre(itemIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                GenreConfigController.this.tab.getView().hideBusyIndicator();
                GenreConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                GenreConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    GenreConfigController.this.tab.setError(GenreConfigController.this.myConstants.deleteFailed());
                    return;
                }
                GenreConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(GenreConfigController.this.myConstants.genreTabName(), GenreConfigController.this.tab.getCommaSeparatedList(itemIds)));
                GenreConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 1) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getGenre(ids[0], (AsyncCallback<UiGenre>)new NeptuneAsyncCallback<UiGenre>(){

            public void onNeptuneFailure(Throwable caught) {
                GenreConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiGenre result) {
                GenreConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiGenre item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateGenre(item, (AsyncCallback<UiGenre>)new NeptuneAsyncCallback<UiGenre>(){

            public void onNeptuneFailure(Throwable caught) {
                GenreConfigController.this.tab.setError(caught.getMessage());
                GenreConfigController.this.tab.refreshCreateView(item);
                GenreConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiGenre result) {
                GenreConfigController.this.tab.refreshCreateView(null);
                GenreConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(GenreConfigController.this.myConstants.genreTabName(), item.getGenre()));
                GenreConfigController.this.tab.getView().hideBusyIndicator();
                GenreConfigController.this.getList();
                GenreConfigController.this.tab.showListPanel();
            }
        });
    }
}

