/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.GenreConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.GenreDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.UiGenreRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class GenreConfigTab
extends MetadataConfigTab<UiGenre, String, UiGenreRecord> {
    private boolean createViewInitialized = false;
    private TextBox genreTxt = null;
    private TextArea descriptionTxt = null;

    public GenreConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new GenreConfigController(this);
    }

    @Override
    public void refreshCreateView(UiGenre item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.genreTxt = new TextBox();
                this.genreTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.gColumnHeadingGenre()), (Widget)this.genreTxt, true);
                this.descriptionTxt = new TextArea();
                this.descriptionTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.gColumnHeadingDescription()), (Widget)this.descriptionTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.genreTxt.setText("");
                this.descriptionTxt.setText("");
            } else {
                this.genreTxt.setText(item.getGenre() == null ? "" : item.getGenre());
                this.descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
            }
        }
    }

    @Override
    protected Table<String, UiGenreRecord> createTable() {
        GenreDataProvider dataProvider = new GenreDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiGenreRecord>)tbl);
        List<Column<?, UiGenreRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiGenreRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiGenreRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String genre = this.genreTxt.getText();
        if (this.isBlank(genre)) {
            return this.constants.errBlankGenre();
        }
        if (genre.trim().length() > 64) {
            return this.constants.errGenreTooLong();
        }
        String description = this.descriptionTxt.getText();
        if (!this.isBlank(description) && description.trim().length() > 255) {
            return this.constants.errDescriptionTooLong();
        }
        return "";
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiGenre genre = new UiGenre();
            genre.setGenre(this.genreTxt.getText().trim());
            genre.setDescription(this.descriptionTxt.getText().trim());
            this.controller.update(genre);
        }
    }
}

