/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.GenreConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre.UiGenreRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

public class GenreDataProvider
implements DataProvider<String, UiGenreRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiGenreConfigServiceAsync service = (UiGenreConfigServiceAsync)GWT.create(UiGenreConfigService.class);
    private Table<String, UiGenreRecord> table;
    private List<Column<?, UiGenreRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private GenreConfigTab tab;

    public GenreDataProvider(MetadataConfigLazyView view, GenreConfigTab tab) {
        this.tab = tab;
        this.view = view;
    }

    public List<Column<?, UiGenreRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiGenreRecord>)new ColumnBase<UiGenreRecord, UiGenreRecord>("GENRE", this.myConstants.gColumnHeadingGenre()){

            public View<UiGenreRecord> getView(final UiGenreRecord record) {
                return new View<UiGenreRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getGenreDisplay());
                        label.setTitle(record.getGenre().getGenre());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiGenreRecord>)new ColumnBase<UiGenreRecord, UiGenreRecord>("DESCRIPTION", this.myConstants.gColumnHeadingDescription()){

            public View<UiGenreRecord> getView(final UiGenreRecord record) {
                return new View<UiGenreRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
                        label.setTitle(record.getGenre().getDescription());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiGenreRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiGenreRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllGenre(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiGenre>>)new NeptuneAsyncCallback<List<UiGenre>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (GenreDataProvider.this.tab != null) {
                    GenreDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                GenreDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiGenre> result) {
                callback.onSuccess((Object)GenreDataProvider.this.convertRecords(result));
                GenreDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiGenreRecord> convertRecords(List<UiGenre> results) {
        ArrayList<UiGenreRecord> retVal = new ArrayList<UiGenreRecord>();
        for (UiGenre item : results) {
            retVal.add(new UiGenreRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiGenreRecord> table) {
        this.table = table;
    }
}

