/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.UiProductRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class ProductConfigController
implements IMetadataConfigController<UiProduct> {
    private UiProductConfigServiceAsync service = (UiProductConfigServiceAsync)GWT.create(UiProductConfigService.class);
    private MetadataConfigTab<UiProduct, String, UiProductRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public ProductConfigController(MetadataConfigTab<UiProduct, String, UiProductRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        this.service.deleteProduct(itemIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                ProductConfigController.this.tab.getView().hideBusyIndicator();
                ProductConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                ProductConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    ProductConfigController.this.tab.setError(ProductConfigController.this.myConstants.deleteFailed());
                    return;
                }
                ProductConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(ProductConfigController.this.myConstants.productTabName(), ProductConfigController.this.tab.getCommaSeparatedList(itemIds)));
                ProductConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 1) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getProduct(ids[0], (AsyncCallback<UiProduct>)new NeptuneAsyncCallback<UiProduct>(){

            public void onNeptuneFailure(Throwable caught) {
                ProductConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiProduct result) {
                ProductConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiProduct item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateProduct(item, (AsyncCallback<UiProduct>)new NeptuneAsyncCallback<UiProduct>(){

            public void onNeptuneFailure(Throwable caught) {
                ProductConfigController.this.tab.setError(caught.getMessage());
                ProductConfigController.this.tab.refreshCreateView(item);
                ProductConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiProduct result) {
                ProductConfigController.this.tab.refreshCreateView(null);
                ProductConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(ProductConfigController.this.myConstants.productTabName(), item.getProductCode()));
                ProductConfigController.this.tab.getView().hideBusyIndicator();
                ProductConfigController.this.getList();
                ProductConfigController.this.tab.showListPanel();
            }
        });
    }
}

