/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.ProductConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.ProductDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.UiProductRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class ProductConfigTab
extends MetadataConfigTab<UiProduct, String, UiProductRecord> {
    private boolean createViewInitialized = false;
    private TextBox productCodeTxt = null;
    private TextArea descriptionTxt = null;

    public ProductConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new ProductConfigController(this);
    }

    @Override
    public void refreshCreateView(UiProduct item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.productCodeTxt = new TextBox();
                this.productCodeTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.pColumnHeadingProductCode()), (Widget)this.productCodeTxt, true);
                this.descriptionTxt = new TextArea();
                this.descriptionTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.pColumnHeadingDescription()), (Widget)this.descriptionTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.productCodeTxt.setText("");
                this.descriptionTxt.setText("");
            } else {
                this.productCodeTxt.setText(item.getProductCode() == null ? "" : item.getProductCode());
                this.descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
            }
        }
    }

    @Override
    protected Table<String, UiProductRecord> createTable() {
        ProductDataProvider dataProvider = new ProductDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiProductRecord>)tbl);
        List<Column<?, UiProductRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiProductRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiProductRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String productCode = this.productCodeTxt.getText();
        if (this.isBlank(productCode)) {
            return this.constants.errBlankProductCode();
        }
        if (productCode.trim().length() > 64) {
            return this.constants.errProductCodeTooLong();
        }
        String description = this.descriptionTxt.getText();
        if (!this.isBlank(description) && description.trim().length() > 255) {
            return this.constants.errDescriptionTooLong();
        }
        return "";
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiProduct product = new UiProduct();
            product.setProductCode(this.productCodeTxt.getText().trim());
            product.setDescription(this.descriptionTxt.getText().trim());
            this.controller.update(product);
        }
    }
}

