/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.ProductConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product.UiProductRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

public class ProductDataProvider
implements DataProvider<String, UiProductRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiProductConfigServiceAsync service = (UiProductConfigServiceAsync)GWT.create(UiProductConfigService.class);
    private Table<String, UiProductRecord> table;
    private List<Column<?, UiProductRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private ProductConfigTab tab;

    public ProductDataProvider(MetadataConfigLazyView view, ProductConfigTab tab) {
        this.tab = tab;
        this.view = view;
    }

    public List<Column<?, UiProductRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiProductRecord>)new ColumnBase<UiProductRecord, UiProductRecord>("PRODUCTCODE", this.myConstants.pColumnHeadingProductCode()){

            public View<UiProductRecord> getView(final UiProductRecord record) {
                return new View<UiProductRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getProductCodeDisplay());
                        label.setTitle(record.getProduct().getProductCode());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiProductRecord>)new ColumnBase<UiProductRecord, UiProductRecord>("DESCRIPTION", this.myConstants.pColumnHeadingDescription()){

            public View<UiProductRecord> getView(final UiProductRecord record) {
                return new View<UiProductRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
                        label.setTitle(record.getProduct().getDescription());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiProductRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiProductRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllProducts(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiProduct>>)new NeptuneAsyncCallback<List<UiProduct>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (ProductDataProvider.this.tab != null) {
                    ProductDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                ProductDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiProduct> result) {
                callback.onSuccess((Object)ProductDataProvider.this.convertRecords(result));
                ProductDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiProductRecord> convertRecords(List<UiProduct> results) {
        ArrayList<UiProductRecord> retVal = new ArrayList<UiProductRecord>();
        for (UiProduct item : results) {
            retVal.add(new UiProductRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiProductRecord> table) {
        this.table = table;
    }
}

