/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.UiRatingRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RatingConfigController
implements IMetadataConfigController<UiRating> {
    private UiRatingConfigServiceAsync service = (UiRatingConfigServiceAsync)GWT.create(UiRatingConfigService.class);
    private MetadataConfigTab<UiRating, String, UiRatingRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public RatingConfigController(MetadataConfigTab<UiRating, String, UiRatingRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        HashMap<String, String> itemsMap = new HashMap<String, String>();
        for (String item : itemIds) {
            String[] arr = item.split("::");
            itemsMap.put(arr[0], arr[1]);
        }
        this.service.deleteRating(itemsMap, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                RatingConfigController.this.tab.getView().hideBusyIndicator();
                RatingConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                RatingConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    RatingConfigController.this.tab.setError(RatingConfigController.this.myConstants.deleteFailed());
                    return;
                }
                RatingConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(RatingConfigController.this.myConstants.ratingTabName(), RatingConfigController.this.tab.getCommaSeparatedList(RatingConfigController.this.getRatingAndSystemList(itemIds))));
                RatingConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 2) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getRating(ids[0], ids[1], (AsyncCallback<UiRating>)new NeptuneAsyncCallback<UiRating>(){

            public void onNeptuneFailure(Throwable caught) {
                RatingConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiRating result) {
                RatingConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiRating item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateRating(item, (AsyncCallback<UiRating>)new NeptuneAsyncCallback<UiRating>(){

            public void onNeptuneFailure(Throwable caught) {
                RatingConfigController.this.tab.setError(caught.getMessage());
                RatingConfigController.this.tab.refreshCreateView(item);
                RatingConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiRating result) {
                RatingConfigController.this.tab.refreshCreateView(null);
                RatingConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(RatingConfigController.this.myConstants.ratingTabName(), RatingConfigController.this.getRatingAndSystemForDisplay(item.getRating(), item.getRatingSystem())));
                RatingConfigController.this.tab.getView().hideBusyIndicator();
                RatingConfigController.this.getList();
                RatingConfigController.this.tab.showListPanel();
            }
        });
    }

    private String getRatingAndSystemForDisplay(String key1, String key2) {
        return "[" + key1 + ", " + key2 + "]";
    }

    private String getRatingAndSystemForDisplay(String item) {
        String[] arr = item.split("::");
        if (arr.length != 2) {
            return item;
        }
        return this.getRatingAndSystemForDisplay(arr[0], arr[1]);
    }

    private List<String> getRatingAndSystemList(List<String> itemIds) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (String item : itemIds) {
            retVal.add(this.getRatingAndSystemForDisplay(item));
        }
        return retVal;
    }
}

