/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.RatingConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.RatingDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.UiRatingRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class RatingConfigTab
extends MetadataConfigTab<UiRating, String, UiRatingRecord> {
    private boolean createViewInitialized = false;
    private TextBox ratingTxt = null;
    private TextBox ratingSystemTxt = null;
    private TextArea descriptionTxt = null;

    public RatingConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new RatingConfigController(this);
    }

    @Override
    public void refreshCreateView(UiRating item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.ratingTxt = new TextBox();
                this.ratingTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.rColumnHeadingRating()), (Widget)this.ratingTxt, true);
                this.ratingSystemTxt = new TextBox();
                this.ratingSystemTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.rColumnHeadingRatingSystem()), (Widget)this.ratingSystemTxt, true);
                this.descriptionTxt = new TextArea();
                this.descriptionTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.gColumnHeadingDescription()), (Widget)this.descriptionTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.ratingTxt.setText("");
                this.ratingSystemTxt.setText("");
                this.descriptionTxt.setText("");
            } else {
                this.ratingTxt.setText(item.getRating() == null ? "" : item.getRating());
                this.ratingSystemTxt.setText(item.getRatingSystem() == null ? "" : item.getRatingSystem());
                this.descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
            }
        }
    }

    @Override
    protected Table<String, UiRatingRecord> createTable() {
        RatingDataProvider dataProvider = new RatingDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiRatingRecord>)tbl);
        List<Column<?, UiRatingRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiRatingRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiRatingRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String rating = this.ratingTxt.getText();
        String ratingSystem = this.ratingSystemTxt.getText();
        if (this.isBlank(rating)) {
            return this.constants.errBlankRating();
        }
        if (this.isBlank(ratingSystem)) {
            return this.constants.errBlankRatingSystem();
        }
        if (rating.trim().length() > 64) {
            return this.constants.errRatingTooLong();
        }
        if (ratingSystem.trim().length() > 64) {
            return this.constants.errRatingSystemTooLong();
        }
        String description = this.descriptionTxt.getText();
        if (!this.isBlank(description) && description.trim().length() > 255) {
            return this.constants.errDescriptionTooLong();
        }
        return "";
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiRating rating = new UiRating();
            rating.setRating(this.ratingTxt.getText().trim());
            rating.setRatingSystem(this.ratingSystemTxt.getText().trim());
            rating.setDescription(this.descriptionTxt.getText().trim());
            this.controller.update(rating);
        }
    }
}

