/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.RatingConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating.UiRatingRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

public class RatingDataProvider
implements DataProvider<String, UiRatingRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiRatingConfigServiceAsync service = (UiRatingConfigServiceAsync)GWT.create(UiRatingConfigService.class);
    private Table<String, UiRatingRecord> table;
    private List<Column<?, UiRatingRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private RatingConfigTab tab;

    public RatingDataProvider(MetadataConfigLazyView view, RatingConfigTab tab) {
        this.tab = tab;
        this.view = view;
    }

    public List<Column<?, UiRatingRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiRatingRecord>)new ColumnBase<UiRatingRecord, UiRatingRecord>("RATING", this.myConstants.rColumnHeadingRating()){

            public View<UiRatingRecord> getView(final UiRatingRecord record) {
                return new View<UiRatingRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getRatingDisplay());
                        label.setTitle(record.getRating().getRating());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiRatingRecord>)new ColumnBase<UiRatingRecord, UiRatingRecord>("RATINGSYSTEM", this.myConstants.rColumnHeadingRatingSystem()){

            public View<UiRatingRecord> getView(final UiRatingRecord record) {
                return new View<UiRatingRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getRatingSystemDisplay());
                        label.setTitle(record.getRating().getRatingSystem());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiRatingRecord>)new ColumnBase<UiRatingRecord, UiRatingRecord>("DESCRIPTION", this.myConstants.rColumnHeadingDescription()){

            public View<UiRatingRecord> getView(final UiRatingRecord record) {
                return new View<UiRatingRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
                        label.setTitle(record.getRating().getDescription());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiRatingRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiRatingRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllRatings(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiRating>>)new NeptuneAsyncCallback<List<UiRating>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (RatingDataProvider.this.tab != null) {
                    RatingDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                RatingDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiRating> result) {
                callback.onSuccess((Object)RatingDataProvider.this.convertRecords(result));
                RatingDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiRatingRecord> convertRecords(List<UiRating> results) {
        ArrayList<UiRatingRecord> retVal = new ArrayList<UiRatingRecord>();
        for (UiRating item : results) {
            retVal.add(new UiRatingRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiRatingRecord> table) {
        this.table = table;
    }
}

