/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.UiStudioRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class StudioConfigController
implements IMetadataConfigController<UiStudio> {
    private UiStudioConfigServiceAsync service = (UiStudioConfigServiceAsync)GWT.create(UiStudioConfigService.class);
    private MetadataConfigTab<UiStudio, String, UiStudioRecord> tab;
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);

    public StudioConfigController(MetadataConfigTab<UiStudio, String, UiStudioRecord> tab) {
        this.tab = tab;
    }

    @Override
    public void getList() {
        this.tab.getTable().refresh();
    }

    @Override
    public void delete(final List<String> itemIds) {
        this.tab.getView().showBusyIndicator();
        this.service.deleteStuido(itemIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                StudioConfigController.this.tab.getView().hideBusyIndicator();
                StudioConfigController.this.tab.setError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                StudioConfigController.this.tab.getView().hideBusyIndicator();
                if (!result.booleanValue()) {
                    StudioConfigController.this.tab.setError(StudioConfigController.this.myConstants.deleteFailed());
                    return;
                }
                StudioConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(StudioConfigController.this.myConstants.studioTabName(), StudioConfigController.this.tab.getCommaSeparatedList(itemIds)));
                StudioConfigController.this.getList();
            }
        });
    }

    @Override
    public void get(String ... ids) {
        if (ids.length != 1) {
            return;
        }
        this.tab.getView().showBusyIndicator();
        this.service.getStudio(ids[0], (AsyncCallback<UiStudio>)new NeptuneAsyncCallback<UiStudio>(){

            public void onNeptuneFailure(Throwable caught) {
                StudioConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiStudio result) {
                StudioConfigController.this.tab.getView().hideBusyIndicator();
            }
        });
    }

    @Override
    public void update(final UiStudio item) {
        this.tab.getView().showBusyIndicator();
        this.service.updateStudio(item, (AsyncCallback<UiStudio>)new NeptuneAsyncCallback<UiStudio>(){

            public void onNeptuneFailure(Throwable caught) {
                StudioConfigController.this.tab.setError(caught.getMessage());
                StudioConfigController.this.tab.refreshCreateView(item);
                StudioConfigController.this.tab.getView().hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiStudio result) {
                StudioConfigController.this.tab.refreshCreateView(null);
                StudioConfigController.this.tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(StudioConfigController.this.myConstants.studioTabName(), item.getDisplayName()));
                StudioConfigController.this.tab.getView().hideBusyIndicator();
                StudioConfigController.this.getList();
                StudioConfigController.this.tab.showListPanel();
            }
        });
    }
}

