/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.StudioConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.StudioDataProvider;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.UiStudioRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import java.util.ArrayList;
import java.util.List;

public class StudioConfigTab
extends MetadataConfigTab<UiStudio, String, UiStudioRecord> {
    private boolean createViewInitialized = false;
    private TextBox displayNameTxt = null;
    private TextBox organizationNameTxt = null;
    private TextBox organizationCodeTxt = null;
    private TextArea descriptionTxt = null;

    public StudioConfigTab(MetadataConfigLazyView view) {
        super(view);
    }

    @Override
    protected void createController() {
        this.controller = new StudioConfigController(this);
    }

    @Override
    public void refreshCreateView(UiStudio item) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_Create"})) {
            if (!this.createViewInitialized) {
                FormContainer form = new FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant.endOf((HasDirection.Direction)HasDirection.Direction.DEFAULT));
                this.displayNameTxt = new TextBox();
                this.displayNameTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.sColumnHeadingDisplayName()), (Widget)this.displayNameTxt, true);
                this.organizationNameTxt = new TextBox();
                this.organizationNameTxt.addStyleName("content-metadataConfigTab-longText");
                form.addRow(new LabelWidget(this.constants.sColumnHeadingOrganizatinName()), (Widget)this.organizationNameTxt, true);
                this.organizationCodeTxt = new TextBox();
                this.organizationCodeTxt.addStyleName("content-metadataConfigTab-shortText");
                form.addRow(new LabelWidget(this.constants.sColumnHeadingOrganizationCode()), (Widget)this.organizationCodeTxt, false);
                this.descriptionTxt = new TextArea();
                this.descriptionTxt.addStyleName("content-metadataConfigTab-textArea");
                form.addRow(new LabelWidget(this.constants.gColumnHeadingDescription()), (Widget)this.descriptionTxt, false);
                this.createPanel.add((Widget)form);
                this.createViewInitialized = true;
            }
            if (item == null) {
                this.displayNameTxt.setText("");
                this.organizationNameTxt.setText("");
                this.organizationCodeTxt.setText("");
                this.descriptionTxt.setText("");
            } else {
                this.displayNameTxt.setText(item.getDisplayName() == null ? "" : item.getDisplayName());
                this.organizationNameTxt.setText(item.getOrganizationName() == null ? "" : item.getOrganizationName());
                this.organizationCodeTxt.setText(item.getOrganizationCode() == null ? "" : item.getOrganizationCode());
                this.descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
            }
        }
    }

    @Override
    protected Table<String, UiStudioRecord> createTable() {
        StudioDataProvider dataProvider = new StudioDataProvider(this.view, this);
        Table tbl = new Table((DataProvider)dataProvider);
        dataProvider.setTable((Table<String, UiStudioRecord>)tbl);
        List<Column<?, UiStudioRecord>> columns = dataProvider.getColumns();
        SortFeatureImpl sortFeature = new SortFeatureImpl(columns.get(0), SortOrder.ASCENDING);
        sortFeature.getSortableColumns().addAll(columns);
        tbl.addSortFeature((SortFeature)sortFeature);
        tbl.initialize(null);
        return tbl;
    }

    @Override
    public void delete(List<UiStudioRecord> selectedIds) {
        if (Window.confirm((String)this.constants.confirmDelete())) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (UiStudioRecord id : selectedIds) {
                itemIds.add(id.getKey());
            }
            this.controller.delete(itemIds);
        }
    }

    private String validateInput() {
        String displayName = this.displayNameTxt.getText();
        String orgName = this.organizationNameTxt.getText();
        if (this.isBlank(displayName)) {
            return this.constants.errBlankDisplayName();
        }
        if (this.isBlank(orgName)) {
            return this.constants.errBlankOrganizationName();
        }
        if (displayName.trim().length() > 64) {
            return this.constants.errDisplayNameTooLong();
        }
        if (orgName.trim().length() > 255) {
            return this.constants.errOrganizationNameTooLong();
        }
        String orgCode = this.organizationCodeTxt.getText();
        if (!this.isBlank(orgCode) && orgCode.trim().length() > 64) {
            return this.constants.errOrganizationCodeTooLong();
        }
        String description = this.descriptionTxt.getText();
        if (!this.isBlank(description) && description.trim().length() > 255) {
            return this.constants.errDescriptionTooLong();
        }
        return "";
    }

    @Override
    public void save() {
        String err = this.validateInput();
        if (err.length() > 0) {
            this.setError(err);
            return;
        }
        this.clearErrors();
        if (this.controller != null) {
            UiStudio studio = new UiStudio();
            studio.setDisplayName(this.displayNameTxt.getText().trim());
            studio.setOrganizationName(this.organizationNameTxt.getText().trim());
            studio.setOrganizationCode(this.organizationCodeTxt.getText().trim());
            studio.setDescription(this.descriptionTxt.getText().trim());
            this.controller.update(studio);
        }
    }
}

