/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigServiceAsync;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.StudioConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio.UiStudioRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

public class StudioDataProvider
implements DataProvider<String, UiStudioRecord> {
    private MetadataConfigConstants myConstants = (MetadataConfigConstants)GWT.create(MetadataConfigConstants.class);
    private UiStudioConfigServiceAsync service = (UiStudioConfigServiceAsync)GWT.create(UiStudioConfigService.class);
    private Table<String, UiStudioRecord> table;
    private List<Column<?, UiStudioRecord>> columns = null;
    private MetadataConfigLazyView view = null;
    private String lastColumnName = "";
    private SortOrder lastSortOrder = SortOrder.ASCENDING;
    private StudioConfigTab tab;

    public StudioDataProvider(MetadataConfigLazyView view, StudioConfigTab tab) {
        this.tab = tab;
        this.view = view;
    }

    public List<Column<?, UiStudioRecord>> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ArrayList();
        this.columns.add((Column<?, UiStudioRecord>)new ColumnBase<UiStudioRecord, UiStudioRecord>("DISPLAYNAME", this.myConstants.sColumnHeadingDisplayName()){

            public View<UiStudioRecord> getView(final UiStudioRecord record) {
                return new View<UiStudioRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDisplayNameDisplay());
                        label.setTitle(record.getStudio().getDisplayName());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiStudioRecord>)new ColumnBase<UiStudioRecord, UiStudioRecord>("ORGANIZATIONNAME", this.myConstants.sColumnHeadingOrganizatinName()){

            public View<UiStudioRecord> getView(final UiStudioRecord record) {
                return new View<UiStudioRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getOrganizationNameDisplay());
                        label.setTitle(record.getStudio().getOrganizationName());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiStudioRecord>)new ColumnBase<UiStudioRecord, UiStudioRecord>("ORGANIZATIONCODE", this.myConstants.sColumnHeadingOrganizationCode()){

            public View<UiStudioRecord> getView(final UiStudioRecord record) {
                return new View<UiStudioRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getOrganizationCodeDisplay());
                        label.setTitle(record.getStudio().getOrganizationCode());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        this.columns.add((Column<?, UiStudioRecord>)new ColumnBase<UiStudioRecord, UiStudioRecord>("DESCRIPTION", this.myConstants.sColumnHeadingDescription()){

            public View<UiStudioRecord> getView(final UiStudioRecord record) {
                return new View<UiStudioRecord>(){

                    public String getStyleName() {
                        return null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
                        label.setTitle(record.getStudio().getDescription());
                        return label;
                    }

                    public void release() {
                    }
                };
            }
        });
        return this.columns;
    }

    public void getRecord(String key, AsyncCallback<UiStudioRecord> callback) {
        callback.onSuccess(null);
    }

    public void getRecords(final AsyncCallback<List<UiStudioRecord>> callback) {
        String columnName = this.table.getSortFeature().getSortColumn().getName();
        SortOrder sortOrder = this.table.getSortFeature().getSortOrder();
        if (!(columnName.equalsIgnoreCase(this.lastColumnName) && sortOrder.equals((Object)this.lastSortOrder) || this.tab == null)) {
            this.tab.clearErrors();
        }
        this.lastColumnName = columnName;
        this.lastSortOrder = sortOrder;
        this.view.showBusyIndicator();
        this.service.getAllStudios(columnName, sortOrder.equals((Object)SortOrder.DESCENDING), (AsyncCallback<List<UiStudio>>)new NeptuneAsyncCallback<List<UiStudio>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (StudioDataProvider.this.tab != null) {
                    StudioDataProvider.this.tab.setError(caught.getMessage());
                }
                callback.onFailure(null);
                StudioDataProvider.this.view.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiStudio> result) {
                callback.onSuccess((Object)StudioDataProvider.this.convertRecords(result));
                StudioDataProvider.this.view.hideBusyIndicator();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private List<UiStudioRecord> convertRecords(List<UiStudio> results) {
        ArrayList<UiStudioRecord> retVal = new ArrayList<UiStudioRecord>();
        for (UiStudio item : results) {
            retVal.add(new UiStudioRecord(item));
        }
        return retVal;
    }

    public void setTable(Table<String, UiStudioRecord> table) {
        this.table = table;
    }
}

