/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.portlet.activity;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletConfig;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletData;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletRecord;
import com.tandbergtv.cms.portal.content.client.portlet.activity.IActivityPortletService;
import com.tandbergtv.cms.portal.content.client.portlet.activity.IActivityPortletServiceAsync;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ImageHyperlink;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.List;

public class ActivityPortlet
extends Portlet {
    ActivityPortletConfig config;
    private NeptuneSecurity security;
    private IActivityPortletServiceAsync service;
    private PortletConstants constants;
    private Timer refreshTimer;
    private FlexTableContainer table;
    private SimplePanel empty;

    public ActivityPortlet(NeptuneSecurity security, ActivityPortletConfig config) {
        super("ACTIVITY");
        this.security = security;
        this.config = config;
        this.service = (IActivityPortletServiceAsync)GWT.create(IActivityPortletService.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.actTitle());
        this.setDisplayName(this.constants.actTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.actNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                ActivityPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.service.getData(this.config.getRecordCount(), (AsyncCallback<ActivityPortletData>)new NeptuneAsyncCallback<ActivityPortletData>(){

            public void onNeptuneFailure(Throwable caught) {
                ActivityPortlet.this.table.removeAllRows();
            }

            public void onNeptuneSuccess(ActivityPortletData result) {
                if (result.getRecords().size() > 0) {
                    ActivityPortlet.this.table.removeAllRows();
                    List<ActivityPortletRecord> records = result.getRecords();
                    if (records != null && !records.isEmpty()) {
                        ActivityPortlet.this.createTableHeader(ActivityPortlet.this.table);
                        int row = 0;
                        while (row < records.size()) {
                            ActivityPortletRecord rec = records.get(row);
                            ActivityPortlet.this.createTableRecord(ActivityPortlet.this.table, row + 1, rec);
                            ++row;
                        }
                    }
                    ActivityPortlet.this.empty.setVisible(false);
                    ActivityPortlet.this.table.setVisible(true);
                } else {
                    ActivityPortlet.this.empty.setVisible(true);
                    ActivityPortlet.this.table.setVisible(false);
                }
                ActivityPortlet.this.update();
            }
        });
    }

    private void createTableRecord(FlexTableContainer table, int row, ActivityPortletRecord rec) {
        int colIndex = 0;
        if (this.security.isUserInRole("WorkOrderManagement_View")) {
            table.setWidget(row, colIndex, (Widget)new ImageHyperlink((Image)this.getImage(rec.getStatusName(), rec.getStatusToolTip()), "Workflow.Work Orders.Search.Id=" + rec.getProcessId()));
        } else {
            table.setWidget(row, colIndex, (Widget)this.getImage(rec.getStatusName(), rec.getStatusToolTip()));
        }
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
        table.setWidget(row, ++colIndex, (Widget)new HyperlinkWidget(rec.getTitle(), "Content.Search.Id=" + rec.getTitleId() + "&Tab=Activity"));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
        ++colIndex;
        if (rec.getSiteName() != null) {
            if (this.security.isUserInRole("Sites_View")) {
                table.setWidget(row, colIndex, (Widget)new HyperlinkWidget(rec.getSiteName(), "Sites.View?id=" + rec.getSiteId()));
            } else {
                table.setWidget(row, colIndex, (Widget)new LabelWidget(rec.getSiteName()));
            }
            table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
        }
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(rec.getProcessName()));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
        String startDate = rec.getStartTime() == null ? "N/A" : rec.getStartTime();
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(startDate));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
    }

    private void createTableHeader(FlexTableContainer table) {
        int row = 0;
        int col = 0;
        table.setWidget(row, col, (Widget)new LabelWidget("Status"));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget("Title ID"));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget("Site Name"));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget("Process Name"));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget("Start Time"));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
    }

    private ImageWidget getImage(String stateName, String toolTip) {
        ImageWidget image = new ImageWidget("images/icon_rect_" + stateName + ".png");
        if (toolTip == null) {
            image.setTitle(this.getLocalizedStateName(stateName));
        } else {
            image.setTitle(toolTip);
        }
        return image;
    }

    private String getLocalizedStateName(String stateName) {
        return this.constants.getString("status" + stateName);
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            ActivityPortlet.this.refreshTimer.scheduleRepeating(ActivityPortlet.this.config.getRefreshRateSecs() * 1000);
            ActivityPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            ActivityPortlet.this.refreshTimer.cancel();
        }
    }
}

