/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.portlet.cmsusage;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsageMonitorConfig;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsagePortletData;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsagePortletRecord;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.ICMSUsagePortletService;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.ICMSUsagePortletServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.List;

public class CMSUsageMonitor
extends Portlet {
    private CMSUsageMonitorConfig config;
    private FlexTableContainer table;
    private SimplePanel empty;
    private Timer refreshTimer;
    private PortletConstants constants;
    private ICMSUsagePortletServiceAsync portletService;
    private static final String CMS_USAGE_PORTLET_STYLE = "cms-usage-portlet";

    public CMSUsageMonitor(NeptuneSecurity security, CMSUsageMonitorConfig config) {
        super("USAGE");
        this.config = config;
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.portletService = (ICMSUsagePortletServiceAsync)GWT.create(ICMSUsagePortletService.class);
        this.setTitle(this.constants.labelTitle());
        this.setDisplayName(this.constants.labelTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.add((Widget)this.table);
        this.setStyleName(CMS_USAGE_PORTLET_STYLE, true);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.labelNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                CMSUsageMonitor.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.portletService.getData((AsyncCallback<CMSUsagePortletData>)new NeptuneAsyncCallback<CMSUsagePortletData>(){

            public void onNeptuneFailure(Throwable caught) {
                CMSUsageMonitor.this.table.removeAllRows();
            }

            public void onNeptuneSuccess(CMSUsagePortletData result) {
                if (!result.getRecords().isEmpty()) {
                    CMSUsageMonitor.this.table.removeAllRows();
                    List<CMSUsagePortletRecord> records = result.getRecords();
                    if (records != null && !records.isEmpty()) {
                        CMSUsageMonitor.this.createTableHeader(CMSUsageMonitor.this.table);
                        int row = 0;
                        while (row < 4) {
                            CMSUsagePortletRecord rec = records.get(row);
                            CMSUsageMonitor.this.createTableRecord(CMSUsageMonitor.this.table, row + 1, rec);
                            ++row;
                        }
                    }
                    CMSUsageMonitor.this.table.setVisible(true);
                    CMSUsageMonitor.this.empty.setVisible(false);
                } else {
                    CMSUsageMonitor.this.table.setVisible(false);
                    CMSUsageMonitor.this.empty.setVisible(true);
                }
                CMSUsageMonitor.this.update();
            }
        });
    }

    private void createTableRecord(FlexTableContainer table, int row, CMSUsagePortletRecord rec) {
        int colIndex = 0;
        table.setWidget(row, colIndex, (Widget)new ImageWidget("images/icon_tri_severity-" + rec.getStateName() + ".png"));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(rec.getLabel()));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(String.valueOf(rec.getCurrentCount())));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
        String maxVal = String.valueOf(rec.getmaxValue());
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(maxVal.equals("0") ? "Unlimited" : maxVal));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
        String percentageVal = String.valueOf(rec.getPercentage());
        table.setWidget(row, ++colIndex, (Widget)new LabelWidget(percentageVal.equals("0.0") && maxVal.equals("0") ? "Unrestricted" : percentageVal));
        table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-icons");
    }

    private void createTableHeader(FlexTableContainer table) {
        int row = 0;
        int col = 0;
        table.setWidget(row, col, (Widget)new LabelWidget(this.constants.labelStatus()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget(this.constants.labelType()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget(this.constants.labelCurrentMonth()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget(this.constants.labelMaximum()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
        table.setWidget(row, ++col, (Widget)new LabelWidget(this.constants.labelPercentage()));
        table.getCellFormatter().setStyleName(row, col, "portlet-tableHeader");
        table.getCellFormatter().addStyleName(row, col, "activityportlet-tablecolumn" + col + "-width");
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            CMSUsageMonitor.this.refreshTimer.scheduleRepeating(CMSUsageMonitor.this.config.getRefreshRateSecs() * 1000);
            CMSUsageMonitor.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            CMSUsageMonitor.this.refreshTimer.cancel();
        }
    }
}

