/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.portlet.modified;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitleRecord;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitlesData;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.TitleMetadata;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ImageHyperlink;
import com.tandbergtv.cms.portal.content.client.portlet.modified.IModifiedTitlesListPortletService;
import com.tandbergtv.cms.portal.content.client.portlet.modified.IModifiedTitlesListPortletServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import java.util.List;
import java.util.Map;

public class LastModifiedPortlet
extends Portlet {
    private NeptuneSecurity security;
    private FlexTableContainer table;
    private SimplePanel empty;
    private Timer refreshTimer;
    private PortletConstants constants;
    private SpecificationServiceAsync tableService;
    private IModifiedTitlesListPortletServiceAsync portletService;
    String spec;
    private static final String TABLE_NAME = "title.portlet.Metadata";
    private String SPECIFICATION_KEY = "ContentComponent.Specification";
    private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";
    private int refreshPeriod;
    private UiTable uiTable;
    private Map<String, String> info;

    public LastModifiedPortlet(NeptuneSecurity security, Map<String, String> info, int refreshTimeInSecs) {
        super("Last_Modified");
        this.security = security;
        this.info = info;
        this.spec = this.getSpecificationName();
        this.refreshPeriod = this.getRefreshPeriodInMills(refreshTimeInSecs);
        this.tableService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.portletService = (IModifiedTitlesListPortletServiceAsync)GWT.create(IModifiedTitlesListPortletService.class);
        this.setTitle(this.constants.modifiedTitle());
        this.setDisplayName(this.constants.modifiedTitle());
        this.table = new FlexTableContainer();
        this.table.setCellSpacing(0);
        this.table.setStyleName("portletTable");
        this.add((Widget)this.table);
        this.empty = new SimplePanel((Widget)new LabelWidget(this.constants.modifiedNoData()));
        this.add((Widget)this.empty);
        this.refreshTimer = new Timer(){

            public void run() {
                LastModifiedPortlet.this.reload();
            }
        };
        EventHandler handler = new EventHandler();
        this.addDocumentAttachHandler(handler);
        this.addDocumentDetachHandler(handler);
    }

    private void reload() {
        this.initializeTable();
        this.portletService.getData((AsyncCallback<ModifiedTitlesData>)new NeptuneAsyncCallback<ModifiedTitlesData>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(ModifiedTitlesData data) {
                if (data.getCount() > 0) {
                    LastModifiedPortlet.this.clearTableData();
                    LastModifiedPortlet.this.prepareTableHeader(data);
                    LastModifiedPortlet.this.populateTableData(data);
                    LastModifiedPortlet.this.table.setVisible(true);
                    LastModifiedPortlet.this.empty.setVisible(false);
                } else {
                    LastModifiedPortlet.this.table.setVisible(false);
                    LastModifiedPortlet.this.empty.setVisible(true);
                }
                LastModifiedPortlet.this.update();
            }
        });
    }

    private void prepareTableHeader(ModifiedTitlesData data) {
        List<UiColumn> columns = this.uiTable.getColumns();
        if (columns == null) {
            return;
        }
        this.table.setWidget(0, 0, (Widget)new LabelWidget(this.constants.titleStatus()));
        this.table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
        int colIndex = 1;
        int i = 0;
        while (i < columns.size()) {
            UiColumn col = columns.get(i);
            String colHeader = col.getDisplayName();
            this.table.setWidget(0, colIndex, (Widget)new LabelWidget(colHeader));
            this.table.getCellFormatter().setStyleName(0, colIndex, "portlet-tableHeader");
            ++colIndex;
            ++i;
        }
        this.table.setWidget(0, colIndex, (Widget)new LabelWidget(this.constants.lastUpdatedTime()));
        this.table.getCellFormatter().setStyleName(0, colIndex, "portlet-tableHeader");
    }

    private void buildStatusWidget(int dataRow, int colIndex, ModifiedTitleRecord record) {
        Image statusImage = new Image();
        new TitleClientBundle().updateTitleStatusIcon(statusImage, record.getStatus(), record.getIsOffer());
        if (this.security.isUserInRole(CONTENT_VIEW_PERMISSION)) {
            this.table.setWidget(dataRow, colIndex, (Widget)new ImageHyperlink(statusImage, "Content.Search.Id=" + record.getTitleId()));
        } else {
            this.table.setWidget(dataRow, colIndex, (Widget)new LabelWidget(this.constants.titleStatus()));
        }
        this.table.getCellFormatter().setStyleName(dataRow, colIndex, "portlet-table-icons");
        if (!record.getIsOffer().booleanValue()) {
            this.table.getCellFormatter().addStyleName(dataRow, colIndex, "portlet-table-icons-default");
        }
    }

    private void populateTableData(ModifiedTitlesData data) {
        List<ModifiedTitleRecord> records = data.getRecords();
        int dataRow = 1;
        int i = 0;
        while (i < records.size()) {
            int colIndex = 0;
            ModifiedTitleRecord record = records.get(i);
            this.buildStatusWidget(dataRow, colIndex, record);
            List<TitleMetadata> metadata = record.getMetadata();
            this.populateTitleMetadata(dataRow, ++colIndex, metadata, record.getTitleId());
            int metdataCount = metadata != null ? metadata.size() : 0;
            this.table.setWidget(dataRow, colIndex += metdataCount, (Widget)new LabelWidget(record.getLastModifiedTime()));
            this.table.getCellFormatter().setStyleName(dataRow, colIndex, "portlet-table-text");
            ++dataRow;
            ++i;
        }
    }

    private void clearTableData() {
        this.table.removeAllRows();
    }

    private void initializeTable() {
        this.tableService.getTable(TABLE_NAME, (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(UiTable uiTable) {
                LastModifiedPortlet.this.setTable(uiTable);
            }
        });
    }

    private void setTable(UiTable table) {
        this.uiTable = table;
    }

    private void populateTitleMetadata(int row, int column, List<TitleMetadata> metadata, long titleId) {
        if (metadata == null) {
            return;
        }
        int i = 0;
        while (i < metadata.size()) {
            int colIndex = column + i;
            if (colIndex == 1 && this.security.isUserInRole(CONTENT_VIEW_PERMISSION)) {
                this.table.setWidget(row, colIndex, this.buildHyperLinkWidget(metadata.get(i).getValue(), "Content.Search.Id=" + titleId));
            } else {
                this.table.setWidget(row, colIndex, (Widget)new LabelWidget(metadata.get(i).getValue()));
            }
            this.table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
            ++i;
        }
    }

    private int getRefreshPeriodInMills(int refresh) {
        return refresh * 1000;
    }

    private String getSpecificationName() {
        return this.info.get(this.SPECIFICATION_KEY);
    }

    private Widget buildHyperLinkWidget(String label, String url) {
        return new HyperlinkWidget(label, url);
    }

    private final class EventHandler
    implements DocumentAttachHandler,
    DocumentDetachHandler {
        private EventHandler() {
        }

        public void onAttach(DocumentAttachEvent event) {
            LastModifiedPortlet.this.refreshTimer.scheduleRepeating(LastModifiedPortlet.this.refreshPeriod);
            LastModifiedPortlet.this.reload();
        }

        public void onDetach(DocumentDetachEvent event) {
            LastModifiedPortlet.this.refreshTimer.cancel();
        }
    }
}

