/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.services.title.AddTitleToOfferResult;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddTitlesToOffer
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private IOffersTitleServiceAsync offerTitleService = (IOffersTitleServiceAsync)GWT.create(IOffersTitleService.class);
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
    }

    public void execute(final List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final TitleActionInput actionInput = (TitleActionInput)input;
        if (actionInput.getOfferTitleId() == 0L) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.selectOfferTitleError()));
            return;
        }
        final BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.center();
        this.offerTitleService.parseSelectedTitlesToOfferMetadata(titleIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(Void result) {
                busyIndicator.hide();
                callback.onSuccess((Object)new AddTitleToOfferResult(actionInput.getOfferTitleId(), titleIds));
            }
        });
    }

    public String getDescription() {
        return this.displayConstants.addTitleToOffer();
    }

    public String getName() {
        return this.displayConstants.addTitleToOfferServiceName();
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        HashMap<String, String> anchorTokens = new HashMap<String, String>();
        anchorTokens.put("Id", String.valueOf(((AddTitleToOfferResult)result).getOfferTitleId()));
        anchorTokens.put("Asset", "ReferenceTitles");
        String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
        History.newItem((String)token);
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getOfferTitleId() != 0L;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }
}

