/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheck;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheckAsync;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheckResponse;
import com.tandbergtv.cms.portal.content.client.services.title.BulkEditResult;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BulkEditService
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static final ContentClassCheckAsync checker = (ContentClassCheckAsync)GWT.create(ContentClassCheck.class);
    private List<Long> titleIds = null;
    private long contentClassId = 0L;
    private TitleListPanel view;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
    }

    public void execute(final List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        this.busyIndicator.center();
        checker.titlesAreOfTheSameContentClass(titleIds, (AsyncCallback<ContentClassCheckResponse>)new NeptuneAsyncCallback<ContentClassCheckResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                BulkEditService.this.busyIndicator.hide();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(ContentClassCheckResponse result) {
                BulkEditService.this.busyIndicator.hide();
                if (titleIds.size() > 0 && result.isSuccess()) {
                    BulkEditService.this.contentClassId = result.getContentClassId();
                    callback.onSuccess((Object)new BulkEditResult());
                } else if (!result.isSuccess()) {
                    callback.onFailure((Throwable)new RuntimeException(BulkEditService.this.displayConstants.bulkEditServiceContentClassError()));
                } else {
                    callback.onFailure((Throwable)new RuntimeException(BulkEditService.this.displayConstants.bulkdEditServiceTileSelectionError()));
                }
            }
        });
        this.titleIds = titleIds;
    }

    public String getDescription() {
        return this.displayConstants.bulkEditServiceDescription();
    }

    public String getName() {
        return this.displayConstants.bulkEditServiceName();
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        this.view = (TitleListPanel)sourceView;
        this.view.showTitleDetails(this.titleIds, this.contentClassId);
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }
}

