/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.TargetSitesResponse;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Distribute
implements ITitleService {
    private String NEWLINE_CHAR = "\n";
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "SITE");
        _serviceActionParameters.put("UPDATE_TYPE", "SINGLE");
    }

    public void execute(List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        ITitleSitesServiceAsync service = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
        service.distributeImmediately(titleIds.get(0), (AsyncCallback<TargetSitesResponse>)new NeptuneAsyncCallback<TargetSitesResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(TargetSitesResponse response) {
                callback.onSuccess((Object)Distribute.this.prepareResult(response));
            }
        });
    }

    private IOperationResult prepareResult(TargetSitesResponse response) {
        StringBuilder sb = new StringBuilder();
        if (response.getTargetTitleIds().size() > 0) {
            sb.append(this.displayConstants.runDistributeSitesServiceSuccess());
            StringBuilder ids = new StringBuilder();
            for (long id : response.getTargetTitleIds()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            sb.append(ids.toString());
        }
        if (response.getFailedIds().size() > 0) {
            sb.append(this.NEWLINE_CHAR);
            sb.append(this.displayConstants.runDistributeSitesServiceFailure());
            StringBuilder failedIds = new StringBuilder();
            for (Map.Entry<Long, String> entry : response.getFailedIds().entrySet()) {
                if (failedIds.length() > 0) {
                    failedIds.append(this.NEWLINE_CHAR);
                }
                failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
            }
            sb.append(failedIds.toString());
        }
        return new DistributeSitesResult(sb.toString());
    }

    public String getDescription() {
        return this.displayConstants.runDistributeSitesServiceDescription();
    }

    public String getName() {
        return this.displayConstants.runDistributeSitesServiceName();
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    public boolean getConfirmation() {
        return true;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }

    private class DistributeSitesResult
    implements IOperationResult {
        String message;

        public DistributeSitesResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

