/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiRuleSet;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleNormalizationRuleServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RunNormalizationRuleService
implements ITitleService {
    public static final String SERVICE_PARAM_SEPARATOR = "ParamSeparator";
    private static final ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static final ITitleNormalizationRuleServiceAsync normalizationRuleService = (ITitleNormalizationRuleServiceAsync)GWT.create(ITitleNormalizationRuleService.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
    }

    public void execute(List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        if (serviceParameter == null || serviceParameter.isEmpty()) {
            callback.onFailure((Throwable)new RuntimeException(displayConstants.runNormalizationRuleServiceRuleSelectionError()));
            return;
        }
        this.busyIndicator.center();
        normalizationRuleService.sendRuleExecutionMessage(titleIds, Integer.valueOf(serviceParameter), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                RunNormalizationRuleService.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(Void result) {
                callback.onSuccess((Object)new RunNormalizationRuleResult(displayConstants.runNormalizationRuleServiceSuccess()));
                RunNormalizationRuleService.this.busyIndicator.hide();
            }
        });
    }

    public String getDescription() {
        return displayConstants.runNormalizationRuleServiceDescription();
    }

    public String getName() {
        return displayConstants.runNormalizationRuleServiceName();
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
        normalizationRuleService.getNormalizationRules((AsyncCallback<List<UiRuleSet>>)new NeptuneAsyncCallback<List<UiRuleSet>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiRuleSet> result) {
                ArrayList<String> serviceParameters = new ArrayList<String>(result.size());
                for (UiRuleSet uiRuleSet : result) {
                    serviceParameters.add(String.valueOf(uiRuleSet.getName()) + RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR + String.valueOf(uiRuleSet.getId()));
                }
                callback.onSuccess(serviceParameters);
            }
        });
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }

    private class RunNormalizationRuleResult
    implements IOperationResult {
        String message;

        public RunNormalizationRuleResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

