/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.TargetSitesResponse;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TargetSites
implements ITitleService {
    private String NEWLINE_CHAR = "\n";
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
    }

    public void execute(List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        if (serviceParameter == null || serviceParameter.isEmpty()) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.runTargetSitesServiceSitesSelectionError()));
            return;
        }
        ArrayList<String> activeSitenames = new ArrayList<String>();
        String[] tokens = serviceParameter.split(",");
        int i = 0;
        while (i < tokens.length) {
            activeSitenames.add(tokens[i]);
            ++i;
        }
        ITitleSitesServiceAsync service = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
        service.target(titleIds, activeSitenames, (AsyncCallback<TargetSitesResponse>)new NeptuneAsyncCallback<TargetSitesResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(TargetSitesResponse response) {
                callback.onSuccess((Object)TargetSites.this.prepareResult(response));
            }
        });
    }

    private IOperationResult prepareResult(TargetSitesResponse response) {
        StringBuilder sb = new StringBuilder();
        if (response.getTargetTitleIds().size() > 0) {
            sb.append(this.displayConstants.runTargetSitesServiceSuccess());
            StringBuilder ids = new StringBuilder();
            for (long id : response.getTargetTitleIds()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            sb.append(ids.toString());
        }
        if (response.getFailedIds().size() > 0) {
            sb.append(this.NEWLINE_CHAR);
            sb.append(this.displayConstants.runTargetSitesServiceFailure());
            StringBuilder failedIds = new StringBuilder();
            for (Map.Entry<Long, String> entry : response.getFailedIds().entrySet()) {
                if (failedIds.length() > 0) {
                    failedIds.append(this.NEWLINE_CHAR);
                }
                failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
            }
            sb.append(failedIds.toString());
        }
        return new TargetSitesResult(sb.toString());
    }

    public String getDescription() {
        return this.displayConstants.runTargetSitesServiceDescription();
    }

    public String getName() {
        return this.displayConstants.runTargetSitesServiceName();
    }

    public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
        ITitleSitesServiceAsync service = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
        service.getActiveDistributionSiteNames((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<String> result) {
                callback.onSuccess(result);
            }
        });
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    public boolean getConfirmation() {
        return true;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }

    private class TargetSitesResult
    implements IOperationResult {
        String message;

        public TargetSitesResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

