/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TerrestrialPitchBottom
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private String NEWLINE_CHAR = "\n";
    private String templateName = "";
    private String queueName = "Terrestrial Queue";
    private String queuePos = "BottomOfQueue";
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
    }

    private void executePitchWork(List<Long> ids, String trackingSiteName, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        IPitchScheduleServiceAsync service = (IPitchScheduleServiceAsync)GWT.create(IPitchScheduleService.class);
        service.sendWorkOrderCreateMessage(ids, trackingSiteName, this.queueName, this.queuePos, this.templateName, (AsyncCallback<WorkOrderCreateResponse>)new NeptuneAsyncCallback<WorkOrderCreateResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(WorkOrderCreateResponse response) {
                callback.onSuccess((Object)TerrestrialPitchBottom.this.prepareResult(response));
            }
        });
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    private IOperationResult prepareResult(WorkOrderCreateResponse response) {
        StringBuilder sb = new StringBuilder();
        if (response.getQueuedWorkOrders().size() > 0) {
            sb.append(this.displayConstants.runTemplateServiceSuccess());
            StringBuilder ids = new StringBuilder();
            for (long id : response.getQueuedWorkOrders()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            sb.append(ids.toString());
        }
        if (response.getFailedIds().size() > 0) {
            sb.append(this.NEWLINE_CHAR);
            sb.append(this.displayConstants.runTemplateServiceFailure());
            StringBuilder failedIds = new StringBuilder();
            for (Map.Entry<Long, String> entry : response.getFailedIds().entrySet()) {
                if (failedIds.length() > 0) {
                    failedIds.append(this.NEWLINE_CHAR);
                }
                failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
            }
            sb.append(failedIds.toString());
        }
        return new ExecutionResult(sb.toString());
    }

    public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
        IPitchScheduleServiceAsync service = (IPitchScheduleServiceAsync)GWT.create(IPitchScheduleService.class);
        service.getTrackingSites((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<String> result) {
                callback.onSuccess(result);
            }
        });
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public String getName() {
        return this.displayConstants.terrestrialPitchBottomServiceName();
    }

    public String getDescription() {
        return this.displayConstants.pitchServiceDescription();
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return false;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }

    public void execute(List<Long> ids, String trackingSiteName, IActionInput input, AsyncCallback<IOperationResult> callback) {
        if (trackingSiteName == null || trackingSiteName.isEmpty()) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.pitchServiceSiteSelectionError()));
            return;
        }
        this.executePitchWork(ids, trackingSiteName, input, callback);
    }

    private class ExecutionResult
    implements IOperationResult {
        String message;

        public ExecutionResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

