/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;
import java.util.MissingResourceException;

public class ErrorPanel
extends SimpleContainer {
    private VerticalContainer mainContainer;
    private LabelWidget headerLabel;
    private LabelWidget messageLabel;
    private String SECTION_HEADING_STYLE = "content-TitleValidationView-sectionHeading";
    private String ERROR_HEADING_STYLE = "content-TitleValidationView-sectionHeading-error";
    private String ERROR_PANEL_STYLE = "content-TitleValidationView";
    private int PANEL_SPACING = 5;
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);

    public ErrorPanel() {
        this.initWidgets();
    }

    private void initWidgets() {
        this.headerLabel = new LabelWidget();
        this.headerLabel.addStyleName(this.SECTION_HEADING_STYLE);
        this.headerLabel.addStyleName(this.ERROR_HEADING_STYLE);
        this.messageLabel = new LabelWidget();
        this.messageLabel.setWordWrap(true);
        this.mainContainer = new VerticalContainer();
        this.mainContainer.add((Widget)this.headerLabel);
        this.mainContainer.add((Widget)this.messageLabel);
        this.mainContainer.addStyleName(this.ERROR_PANEL_STYLE);
        this.mainContainer.setSpacing(this.PANEL_SPACING);
        this.mainContainer.setWidth("99%");
        this.add((Widget)this.mainContainer);
    }

    public void showErrorCodeMessages(List<String> errorCodes) {
        StringBuilder sb = new StringBuilder();
        for (String code : errorCodes) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            try {
                sb.append(this.constants.getString(code));
            }
            catch (MissingResourceException missingResourceException) {
                sb.append(code);
            }
        }
        this.headerLabel.setText(this.messages.titleListSaveFailure(errorCodes.size()));
        this.messageLabel.setText(sb.toString());
    }

    public void showErrorMessage(String message) {
        this.headerLabel.setText(this.messages.titleListSaveFailure(1));
        this.messageLabel.setText(message);
    }

    public void reset() {
        this.messageLabel.setText("");
        this.headerLabel.setText("");
    }
}

