/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.AssetRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleAssetDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ExpandingProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TitleListExpandingProvider
implements ExpandingProvider<Long, TitleRecord, Long, AssetRecord> {
    private Table<Long, TitleRecord> table;
    private UiTable uiTable;
    private Map<TitleRecord, Table<Long, AssetRecord>> tableCacheMap;

    public TitleListExpandingProvider(UiTable uiTable) {
        this.uiTable = uiTable;
        this.tableCacheMap = new HashMap<TitleRecord, Table<Long, AssetRecord>>();
    }

    public List<AssetRecord> getSelectedRecords() {
        ArrayList<AssetRecord> selectedRecords = new ArrayList<AssetRecord>();
        for (Table<Long, AssetRecord> table : this.tableCacheMap.values()) {
            selectedRecords.addAll(table.getSelectedRecords());
        }
        return selectedRecords;
    }

    public List<AssetRecord> getSelectedRecords(TitleRecord parentRecord) {
        ArrayList<AssetRecord> selectedRecords = new ArrayList<AssetRecord>();
        Table<Long, AssetRecord> table = this.tableCacheMap.get(parentRecord);
        if (table != null) {
            selectedRecords.addAll(table.getSelectedRecords());
        }
        return selectedRecords;
    }

    public Widget getWidget(TitleRecord parentRecord) {
        Table table = this.tableCacheMap.get(parentRecord);
        if (table == null) {
            TitleAssetDataProvider dataProvider = new TitleAssetDataProvider(parentRecord, this.uiTable);
            table = new Table((DataProvider)dataProvider);
            table.initialize((AsyncCallback)new TableCallback((Table<Long, AssetRecord>)table));
            table.addSelectionChangeHandler((SelectionChangeHandler)new SelectionChangeHandler<Long, AssetRecord>(){

                public void onSelectionChange(SelectionChangeEvent<Long, AssetRecord> event) {
                    TitleListExpandingProvider.this.handleSelectionChangeEvent((SelectionChangeEvent<Long, AssetRecord>)event);
                }
            });
            this.tableCacheMap.put(parentRecord, (Table<Long, AssetRecord>)table);
        }
        return table;
    }

    private void handleSelectionChangeEvent(SelectionChangeEvent<Long, AssetRecord> event) {
        Set<Map.Entry<TitleRecord, Table<Long, AssetRecord>>> cacheEntrySet = this.tableCacheMap.entrySet();
        for (Map.Entry<TitleRecord, Table<Long, AssetRecord>> entry : cacheEntrySet) {
            Table<Long, AssetRecord> cachedTable = entry.getValue();
            if (!cachedTable.equals((Object)event.getSource())) continue;
            if (cachedTable.getSelectedRecords().size() > 0) {
                this.table.setSelectedForRecord((Record)entry.getKey(), true);
                break;
            }
            this.table.setSelectedForRecord((Record)entry.getKey(), false);
            this.table.setHeaderRowSelected(false);
            break;
        }
    }

    public void parentSelectionChanged(TitleRecord parentRecord, boolean selected) {
        Table<Long, AssetRecord> table = this.tableCacheMap.get(parentRecord);
        if (table == null) {
            this.getWidget(parentRecord);
            table = this.tableCacheMap.get(parentRecord);
            table.addRefreshListener((Table.RefreshListener)new TableRefreshListener(table, selected));
        } else if (table != null) {
            this.changeChildrenSelections(selected, table);
        }
    }

    private void changeChildrenSelections(boolean selected, Table<Long, AssetRecord> table) {
        List dataRowsCheckBoxes = table.getDataRowsCheckBoxes();
        for (CheckBox checkBox : dataRowsCheckBoxes) {
            if (selected) {
                checkBox.setValue(Boolean.valueOf(selected));
                break;
            }
            checkBox.setValue(Boolean.valueOf(selected));
        }
        if (!selected) {
            table.setHeaderRowSelected(false);
        }
    }

    public void setTable(Table<Long, TitleRecord> table) {
        this.table = table;
    }

    public Table<Long, TitleRecord> getTable() {
        return this.table;
    }

    class TableCallback
    extends NeptuneAsyncCallback<Void> {
        private Table<Long, AssetRecord> table;

        public TableCallback(Table<Long, AssetRecord> table) {
            this.table = table;
        }

        public void onNeptuneFailure(Throwable caught) {
            Window.alert((String)caught.getLocalizedMessage());
        }

        public void onNeptuneSuccess(Void result) {
            this.table.refresh();
        }
    }

    class TableRefreshListener
    implements Table.RefreshListener {
        private boolean selected;
        private Table<Long, AssetRecord> table;

        public TableRefreshListener(Table<Long, AssetRecord> table, boolean selected) {
            this.table = table;
            this.selected = selected;
        }

        public void updated() {
            TitleListExpandingProvider.this.changeChildrenSelections(this.selected, (Table<Long, AssetRecord>)this.table);
        }
    }
}

