/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.ResultsLoadedEvent;
import com.tandbergtv.cms.portal.content.client.tab.list.ResultsLoadedHandler;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListExpandingProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListViewInput;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionInput;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnBuilder;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.UiAssetTableDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.TitleListButtonClickListener;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchResultsPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ExpandingProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.ExpandingFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TitleListPanel
extends Composite
implements IView,
HasViewCancelHandlers,
IMessageEmitter {
    private static final String TITLE_ASSET_LIST_TABLE = "titleListAssetColumns";
    private static final String STYLE_NAME = "content-TitleListPanel";
    private static final int SPACING = 2;
    private SimpleContainer rootContainer;
    private VerticalContainer container;
    private NeptuneSecurity security;
    private String specificationName;
    private UITitleFilter titleFilter;
    private ServiceLoader serviceLoader;
    private TitleListViewInput input;
    private Long requestKey;
    private String action;
    private String listOfAssetIds;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private ServiceMap serviceMap = new ServiceMap();
    private final WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private ContentConstants displayConstants;
    private IMessageListener messageListener;
    private Table<Long, TitleRecord> assetTable;
    private UiAssetTableDataProvider dp;
    private ButtonWidget goButton;
    private ButtonWidget cancelButton;
    private ListBoxWidget<String> actionsListBox;
    private ListBoxWidget<String> parameterListBox;
    private ListBoxWidget<String> multiSelectParameterListBox;
    private HorizontalContainer actionListContainer;
    private HorizontalContainer cancelContainer;
    private LabelWidget countWidget;
    private SimpleContainer parentContainer;
    private SearchResultsPanel searchResultsPanel;
    private CookieStoreBasedPageFeatureImpl pageFeature;
    public static final String RESULTS_PAGE_ANCHOR = "Results";
    TitleListButtonClickListener actionButtonHandler = null;
    boolean useMultiSelectParameters = false;
    private List<UiColumn> displayColumns;
    private UiColumn sortColumn;
    private UISortOrder sortOrder;
    private boolean isSeries = false;
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);

    public TitleListPanel(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier, UITitleFilter titleFilter, TitleListViewInput viewInput, Long requestKey, String action, String listOfAssetIds, String infoMessage, boolean isQuickSearch, boolean isSeries, ResultsLoadedHandler loadHandler, List<UiColumn> displayColumns, UiColumn selectedSortColumn, UISortOrder selectedSortOrder, SimpleContainer searchResultsPanelWrapper) {
        this.showBusyIndicator();
        this.displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.titleFilter = titleFilter;
        this.serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
        this.anchorChangeNotifier = anchorChangeNotifier;
        this.input = viewInput;
        this.requestKey = requestKey;
        this.action = action;
        this.listOfAssetIds = listOfAssetIds;
        this.displayColumns = displayColumns;
        this.sortColumn = selectedSortColumn;
        this.sortOrder = selectedSortOrder;
        this.isSeries = isSeries;
        this.parentContainer = searchResultsPanelWrapper;
        this.initWidgets();
        this.setWidgets();
        this.initializeDataProvider(infoMessage, isQuickSearch);
        this.addHandler(loadHandler, ResultsLoadedEvent.TYPE);
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    private void initWidgets() {
        this.rootContainer = new SimpleContainer();
        this.rootContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.rootContainer);
        this.container = new VerticalContainer();
        this.rootContainer.setWidget((Widget)this.container);
        this.container.setSpacing(2);
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        this.multiSelectParameterListBox = new ListBoxWidget(true);
        this.multiSelectParameterListBox.setVisible(false);
        this.cancelButton = new ButtonWidget(this.displayConstants.cancelButtonName());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListPanel.this.cancelClickedAction();
            }
        });
        this.goButton = new ButtonWidget(this.displayConstants.goButtonName());
        this.actionButtonHandler = new TitleListButtonClickListener(this.actionsListBox, this.parameterListBox, this, this.serviceMap);
        this.goButton.addClickHandler((ClickHandler)this.actionButtonHandler);
        this.goButton.removeStyleName("gwt-Button");
        this.goButton.addStyleName("ebBtn");
        this.goButton.addStyleName("ebBtn_color_darkBlue");
        this.goButton.addStyleName("next_button_icon");
        this.buildActionsListWidget();
    }

    private void setWidgets() {
        this.countWidget = new LabelWidget("");
        if (this.titleFilter.isCountIncluded()) {
            this.container.add((Widget)this.countWidget);
        }
    }

    private void cancelClickedAction() {
        this.anchorChangeNotifier.anchorChanged("");
        this.fireEvent((GwtEvent)new ViewCancelEvent());
    }

    private void initializeDataProvider(String infoMessage, boolean isQuickSearch) {
        this.dp = new UiAssetTableDataProvider(this);
        try {
            SearchResultColumnBuilder columnBuilder = new SearchResultColumnBuilder(this);
            List<Column<?, TitleRecord>> colsWithRecord = columnBuilder.buildRecordForColumns(this.displayColumns);
            List<Column<?, TitleRecord>> sortCols = columnBuilder.getSortColumns(this.displayColumns);
            this.dp.init(this.displayColumns);
            this.dp.setDisplayColumns(colsWithRecord);
            this.dp.setSortColumns(sortCols);
            this.show(infoMessage);
            if (this.input.getTitleListId() != 0L) {
                this.initializeExpandingFeatureTable();
            } else {
                this.initializeTable(null);
            }
        }
        catch (Throwable t) {
            this.hideBusyIndicator();
            Window.alert((String)("Failed to initialize Asset Table Data Provider. Reason: " + (t != null ? t.getMessage() : "")));
        }
    }

    private void initializeExpandingFeatureTable() {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(TITLE_ASSET_LIST_TABLE, (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(UiTable table) {
                TitleListPanel.this.initializeTable(table);
            }
        });
    }

    private void initializeTable(UiTable table) {
        TitleListExpandingProvider titleListExpandingProvider = null;
        ExpandingFeatureImpl expandingFeature = null;
        if (table != null) {
            titleListExpandingProvider = new TitleListExpandingProvider(table);
            expandingFeature = new ExpandingFeatureImpl((ExpandingProvider)titleListExpandingProvider);
        }
        this.assetTable = new Table((DataProvider)this.dp, expandingFeature);
        this.pageFeature = new CookieStoreBasedPageFeatureImpl("titleList", true);
        this.dp.setPageFeature((PageFeatureImpl)this.pageFeature);
        Column<?, TitleRecord> sc = null;
        for (Column<?, TitleRecord> record : this.dp.getSortableColumns()) {
            if (!record.getDisplayName().equals(this.sortColumn.getDisplayName())) continue;
            sc = record;
            break;
        }
        SortOrder order = SortOrder.valueOf((String)this.sortOrder.name());
        SortFeatureImpl sortFeature = new SortFeatureImpl(sc, order);
        for (Column<?, TitleRecord> sortableCol : this.dp.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableCol);
        }
        this.dp.setSortFeature((SortFeatureImpl<Long, TitleRecord>)sortFeature);
        this.assetTable.addPageFeature((PageFeature)this.pageFeature);
        this.assetTable.addSortFeature((SortFeature)sortFeature);
        this.container.add(this.assetTable);
        if (titleListExpandingProvider != null) {
            titleListExpandingProvider.setTable(this.assetTable);
        }
        this.assetTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleListPanel.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(Void result) {
                TitleListPanel.this.assetTable.refresh();
            }
        });
    }

    private void buildActionsListWidget() {
        this.actionListContainer = new HorizontalContainer();
        this.cancelContainer = new HorizontalContainer();
        ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(ITitleService.class, this.serviceLoader, this.isSeries);
        for (UiServiceItem item : listItemProvider.getItems(this.serviceMap)) {
            this.actionsListBox.addItem(item.getName(), (Object)item.getClassName());
        }
        this.actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(this.serviceMap, this.input));
        String displayName = this.actionsListBox.getItemText(this.actionsListBox.getSelectedIndex());
        if (displayName.trim().isEmpty()) {
            this.setWidgetsForNoAction();
        }
        final TitleListPanel instance = this;
        this.actionsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleListPanel.this.parameterListBox.setVisible(false);
                TitleListPanel.this.multiSelectParameterListBox.setVisible(false);
                TitleListPanel.this.goButton.setEnabled(false);
                int selectedIndex = TitleListPanel.this.actionsListBox.getSelectedIndex();
                String displayName = TitleListPanel.this.actionsListBox.getItemText(selectedIndex);
                if (displayName.trim().isEmpty()) {
                    TitleListPanel.this.setWidgetsForNoAction();
                    return;
                }
                ITitleActionService selectedAction = TitleListPanel.this.serviceMap.getService(displayName);
                if (selectedAction.getName().equals(TitleListPanel.this.displayConstants.runTargetSitesServiceName())) {
                    TitleListPanel.this.useMultiSelectParameters = true;
                    TitleListPanel.this.actionButtonHandler.setParameterList((ListBoxWidget<String>)TitleListPanel.this.multiSelectParameterListBox);
                } else {
                    TitleListPanel.this.useMultiSelectParameters = false;
                    TitleListPanel.this.actionButtonHandler.setParameterList((ListBoxWidget<String>)TitleListPanel.this.parameterListBox);
                }
                selectedAction.getServiceParameters((NeptuneAsyncCallback)new NeptuneAsyncCallback<List<String>>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleListPanel.this.parameterListBox.setVisible(false);
                        TitleListPanel.this.multiSelectParameterListBox.setVisible(false);
                        instance.reportFailure(caught);
                    }

                    public void onNeptuneSuccess(List<String> result) {
                        if (result != null) {
                            if (!(this).TitleListPanel.this.useMultiSelectParameters) {
                                this.setParameterList((ListBoxWidget<String>)TitleListPanel.this.parameterListBox, result);
                                TitleListPanel.this.parameterListBox.setVisible(true);
                                TitleListPanel.this.multiSelectParameterListBox.setVisible(false);
                            } else {
                                this.setParameterList((ListBoxWidget<String>)TitleListPanel.this.multiSelectParameterListBox, result);
                                TitleListPanel.this.parameterListBox.setVisible(false);
                                TitleListPanel.this.multiSelectParameterListBox.setVisible(true);
                            }
                        }
                        TitleListPanel.this.goButton.setEnabled(true);
                    }
                });
            }

            private void setParameterList(ListBoxWidget<String> listBox, List<String> parameters) {
                listBox.clear();
                Iterator<String> iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    String p;
                    String name = p = iterator.next();
                    String value = p;
                    if (p != null && p.contains("ParamSeparator")) {
                        String[] pArray = p.split("ParamSeparator");
                        if (pArray.length > 0) {
                            name = pArray[0];
                        }
                        if (pArray.length > 1) {
                            value = pArray[1];
                        }
                    }
                    listBox.addItem(name, (Object)value);
                }
            }
        });
        this.cancelContainer.add((Widget)this.cancelButton);
        this.actionListContainer.add(this.actionsListBox);
        this.actionListContainer.add(this.parameterListBox);
        this.actionListContainer.add(this.multiSelectParameterListBox);
        this.actionListContainer.add((Widget)this.goButton);
    }

    private void setWidgetsForNoAction() {
        this.actionsListBox.setSelectedItem((Object)"");
        this.parameterListBox.clear();
        this.parameterListBox.setVisible(false);
        this.goButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public ServiceLoader getServiceLoader() {
        return this.serviceLoader;
    }

    public UITitleFilter getTitleFilter() {
        return this.titleFilter;
    }

    public void setTitleFilter(UITitleFilter titleFilter) {
        this.titleFilter = titleFilter;
    }

    public Table<Long, TitleRecord> getAssetTable() {
        return this.assetTable;
    }

    public Widget getParentContainer() {
        return this.getParent();
    }

    public void reportFailure(Throwable caught) {
        this.showErrorMessage(caught.getMessage());
    }

    public void cleanup() {
        this.input.resetInfo();
        this.countWidget.setText("");
    }

    public void refresh(String infoMessage) {
        this.assetTable.getPageFeature().setPageNumber(1);
        this.assetTable.showListView();
        this.assetTable.refresh();
        this.countWidget.setText("");
        this.rootContainer.setWidget((Widget)this.container);
        this.parentContainer.setWidget((Widget)this.searchResultsPanel);
        this.show(infoMessage);
        if (this.anchorChangeNotifier != null) {
            this.anchorChangeNotifier.anchorChanged(RESULTS_PAGE_ANCHOR);
        }
        this.setWidgetsForNoAction();
    }

    public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
        return this.addHandler((EventHandler)handler, ViewCancelEvent.getType());
    }

    public void showTitleDetails(long titleId) {
        TitleViewInput viewInput = new TitleViewInput(titleId, this.getRequestKey(), this.getAction(), this.getListOfAssetIds());
        TitleView titleView = this.isSeries ? new SeriesTitleView(viewInput) : new TitleView(viewInput);
        titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler(){

            public void onAnchorChange(ViewAnchorChangeEvent event) {
                if (TitleListPanel.this.anchorChangeNotifier != null) {
                    TitleListPanel.this.anchorChangeNotifier.anchorChanged(event.getAnchor());
                }
            }
        });
        titleView.addViewCancelHandler(new ViewCancelHandler(){

            public void onCancel(ViewCancelEvent event) {
                TitleListPanel.this.refresh(null);
            }
        });
        this.parentContainer.setWidget((Widget)titleView);
        if (this.anchorChangeNotifier != null) {
            this.anchorChangeNotifier.anchorChanged(titleView.getAnchor());
        }
    }

    public void showTitleDetails(List<Long> titleIds, long contentClassId) {
        TitleViewInput viewInput = new TitleViewInput(titleIds, contentClassId);
        TitleView titleView = new TitleView(viewInput);
        titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler(){

            public void onAnchorChange(ViewAnchorChangeEvent event) {
                if (TitleListPanel.this.anchorChangeNotifier != null) {
                    TitleListPanel.this.anchorChangeNotifier.anchorChanged(event.getAnchor());
                }
            }
        });
        titleView.addViewCommitHandler(new ViewCommitHandler<TitleViewInput>(){

            public void onCommit(ViewCommitEvent<TitleViewInput> event) {
                String message = String.valueOf(TitleListPanel.this.displayConstants.bulkEditServiceSuccess()) + ((TitleViewInput)event.getData()).getOrderedBulkEditTitleIds();
                TitleListPanel.this.refresh(message);
            }
        });
        titleView.addViewCancelHandler(new ViewCancelHandler(){

            public void onCancel(ViewCancelEvent event) {
                TitleListPanel.this.refresh(null);
            }
        });
        this.parentContainer.setWidget((Widget)titleView);
        if (this.anchorChangeNotifier != null) {
            this.anchorChangeNotifier.anchorChanged(titleView.getAnchor());
        }
    }

    public void show(String infoMessage) {
        this.showInfoMessage(infoMessage);
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(Long requestKey) {
        this.requestKey = requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public void setListOfAssetIds(String listOfAssetIds) {
        this.listOfAssetIds = listOfAssetIds;
    }

    public TitleListViewInput getInput() {
        return this.input;
    }

    public void setInput(TitleListViewInput input) {
        this.input = input;
    }

    public IActionInput getInputToExecution() {
        return new ActionInput(this.getSpecificationName(), this.getInput().getScheduleId(), this.getInput().getTitleListId(), this.getInput().getLicenseId(), this.getInput().getOfferTitleId(), this.titleFilter, this.dp);
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.getAssetTable().getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TitleRecord tr : selectedIds) {
            ids.add(tr.getKey());
        }
        return ids;
    }

    public void show(boolean readOnly) {
        this.goButton.setEnabled(readOnly);
        this.cancelButton.setEnabled(readOnly);
        this.actionsListBox.setEnabled(readOnly);
        this.parameterListBox.setEnabled(readOnly);
        this.multiSelectParameterListBox.setEnabled(readOnly);
    }

    public boolean hasActions() {
        return this.actionsListBox.getItemCount() > 0;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void handleGetRecordsRequest() {
        this.showBusyIndicator();
    }

    public void handleGetRecordsSuccessResponse(List<TitleRecord> records) {
        this.fireEvent(new ResultsLoadedEvent());
        if (this.titleFilter.isCountIncluded()) {
            this.countWidget.setText(this.messages.matchingRecordCount(this.pageFeature.getRecordCount()));
        }
        this.hideBusyIndicator();
    }

    public void handleGetRecordsFailureResponse(Throwable caught) {
        ResultsLoadedEvent event = new ResultsLoadedEvent(caught);
        this.fireEvent(event);
        this.hideBusyIndicator();
    }

    public List<UiColumn> getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(List<UiColumn> displayColumns) {
        this.displayColumns = displayColumns;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void resetMessagePanel() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeNotifier() {
        return this.anchorChangeNotifier;
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public SearchResultsPanel getSearchResultsPanel() {
        return this.searchResultsPanel;
    }

    public void setSearchResultsPanel(SearchResultsPanel searchResultsPanel) {
        this.searchResultsPanel = searchResultsPanel;
    }

    public boolean isSeries() {
        return this.isSeries;
    }
}

