/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.actionlist;

import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActionListDataProvider<S extends ITitleActionService> {
    private ServiceLoader serviceLoader;
    private Class<S> serviceClass;
    private boolean isSeries;
    private boolean isMultipleUpdate;
    private boolean isSiteTitle;
    List<UiServiceItem> items;

    public ActionListDataProvider(Class<S> serviceClass, ServiceLoader serviceLoader, boolean isSeries) {
        this(serviceClass, serviceLoader, isSeries, true, false);
    }

    public ActionListDataProvider(Class<S> serviceClass, ServiceLoader serviceLoader, boolean isSeries, boolean isMultipleUpdate, boolean isSiteTitle) {
        this.serviceLoader = serviceLoader;
        this.serviceClass = serviceClass;
        this.isSeries = isSeries;
        this.isMultipleUpdate = isMultipleUpdate;
        this.isSiteTitle = isSiteTitle;
        this.items = new ArrayList<UiServiceItem>();
    }

    public List<UiServiceItem> getItems(ServiceMap map) {
        List titleServices = this.serviceLoader.loadServices(this.serviceClass);
        this.items.add(new UiServiceItem("", "", ""));
        Iterator iterator = titleServices.iterator();
        while (iterator.hasNext()) {
            ITitleActionService service;
            ITitleActionService s = service = (ITitleActionService)iterator.next();
            Map serviceActionParameters = s.getServiceActionParameters();
            String titleType = (String)serviceActionParameters.get("TITLE_TYPE");
            String updateType = (String)serviceActionParameters.get("UPDATE_TYPE");
            if (titleType == null || updateType == null || this.isMultipleUpdate && !updateType.contains("MULTIPLE") || !this.isMultipleUpdate && !updateType.contains("SINGLE") || this.isSeries && !titleType.contains("SERIES") || this.isSiteTitle && !titleType.contains("SITE") || !this.isSeries && !this.isSiteTitle && !titleType.contains("MASTER")) continue;
            this.items.add(new UiServiceItem(s.getName(), s.getDescription(), s.getClass().getName()));
            map.put(s.getName(), s);
        }
        return this.items;
    }

    public int getSelectedItemIndex(ServiceMap map, ViewInput inputData) {
        int i = 0;
        while (i < map.listAllServices().size()) {
            ITitleActionService service = map.listAllServices().get(i);
            if (service.isSelected(inputData)) {
                return this.getUiItemIndex(service);
            }
            ++i;
        }
        return 0;
    }

    private int getUiItemIndex(ITitleActionService service) {
        int i = 0;
        while (i < this.items.size()) {
            UiServiceItem item = this.items.get(i);
            if (item.getName().equalsIgnoreCase(service.getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

