/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import java.util.List;

public class DistributionStatusLinkView
implements View<String> {
    private TitleViewMessages messages;
    private long titleId = 0L;
    private String distributionStatus;
    private TitleClientBundle bundle;
    private StatusPopup popup;

    public DistributionStatusLinkView(long titleId, String status) {
        this.titleId = titleId;
        this.distributionStatus = status;
        this.bundle = new TitleClientBundle();
        this.popup = new StatusPopup();
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
    }

    public Widget getWidget() {
        ImageWidget statusImage = new ImageWidget();
        this.bundle.updateDistributionStatusIcon((Image)statusImage, this.distributionStatus);
        final ToggleButton button = new ToggleButton((Image)statusImage);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (button.isDown()) {
                    DistributionStatusLinkView.this.buildPopup(DistributionStatusLinkView.this.titleId, button);
                } else {
                    DistributionStatusLinkView.this.hidePopup();
                }
            }
        });
        button.setStyleName("portlet-table-icons");
        return button;
    }

    private void buildPopup(long titleid, ToggleButton button) {
        this.popup.showRelativeTo((UIObject)button);
        this.popup.buildDistributionDetail(titleid);
    }

    private void hidePopup() {
        this.popup.hide(true);
    }

    public String getStyleName() {
        return "table-data-link";
    }

    public void release() {
    }

    protected class StatusPopup
    extends PopupPanel {
        private FlexTableContainer table;
        private ITitleSitesServiceAsync service;
        private ContentConstants myConstants;

        protected StatusPopup() {
            super(true);
            this.service = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
            this.myConstants = (ContentConstants)GWT.create(ContentConstants.class);
            this.table = new FlexTableContainer();
            this.table.setCellSpacing(0);
            this.table.setStyleName("portletTable");
            ScrollPanel panel = new ScrollPanel((Widget)this.table);
            panel.setHeight("400px");
            panel.setWidth("500px");
            this.add((Widget)panel);
        }

        protected void buildDistributionDetail(long titleId) {
            this.service.getTitleSites(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(UITitle result) {
                    StatusPopup.this.prepareTableData(result.getSites());
                }
            });
            this.prepareTableHeader();
        }

        private void prepareTableHeader() {
            this.table.setWidget(0, 0, (Widget)new LabelWidget(this.myConstants.distStatus()));
            this.table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
            this.table.setWidget(0, 1, (Widget)new LabelWidget(this.myConstants.distSites()));
            this.table.getCellFormatter().setStyleName(0, 1, "portlet-tableHeader");
        }

        private void prepareTableData(UITitleSites sites) {
            List<UIDistributionSiteItem> siteTitles = sites.getDistributionSiteItems();
            int row = 1;
            int i = 0;
            while (i < siteTitles.size()) {
                UIDistributionSiteItem item = siteTitles.get(i);
                ImageWidget statusImage = new ImageWidget();
                DistributionStatusLinkView.this.bundle.updateDistributionStatusIcon((Image)statusImage, item.getStatus());
                if (item.getStatus().equalsIgnoreCase(UIDistributionSiteItem.DistributionStatus_FAILED)) {
                    if (item.getStatusDetail() == UIDistributionSiteItem.LIC_LIMIT_EXCEEDED) {
                        statusImage.setTitle(DistributionStatusLinkView.this.messages.distLimitExceeded());
                    } else if (item.getStatusDetail() == UIDistributionSiteItem.DIST_DEPENDENCY_TIMEOUT) {
                        statusImage.setTitle(DistributionStatusLinkView.this.messages.distDependencyTimeout());
                    }
                }
                this.table.setWidget(row, 0, (Widget)statusImage);
                this.table.getCellFormatter().setStyleName(row, 0, "portlet-table-icons");
                this.table.setWidget(row, 1, (Widget)new LabelWidget(item.getName()));
                this.table.getCellFormatter().setStyleName(row, 1, "portlet-table-text");
                ++row;
                ++i;
            }
        }
    }
}

