/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.QuickInfoColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class QuickInfoViewBuilder
implements View<String> {
    private List<UiField> fields;
    private Boolean isOffer;
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static String FIELD_NAME_VALUE_DELIMITER = ":";
    private static String QUICK_INFO_LABEL_STYLE = "quickinfo-label";
    private static String QUICK_INFO_TABLE_STYLE = "quickinfo-table";

    public QuickInfoViewBuilder(TitleRecord record) {
        this.fields = this.extractQuickInfoFields(record.getTitle().getFields());
        this.isOffer = record.isOffer();
    }

    private List<UiField> extractQuickInfoFields(List<UiField> allFields) {
        ArrayList<UiField> qInfoFields = new ArrayList<UiField>();
        List<UiColumn> qInfoCols = QuickInfoColumnProvider.getInstance().getFields();
        block0: for (UiColumn uic : qInfoCols) {
            for (UiField f : allFields) {
                if (!uic.getName().equals(f.getName()) || (uic.getSectionName() != null || f.getParentAssetType() != null) && !uic.getSectionName().equals(f.getParentAssetType())) continue;
                qInfoFields.add(f);
                continue block0;
            }
        }
        return qInfoFields;
    }

    public Boolean getIsOffer() {
        return this.isOffer;
    }

    public void setIsOffer(Boolean isOffer) {
        this.isOffer = isOffer;
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        FlexTable table = new FlexTable();
        VerticalPanel staticFieldWidget = this.getWidgetForStaticInfo();
        table.setWidget(0, 0, (Widget)staticFieldWidget);
        VerticalContainer dynamicFieldWidget = this.getDynamicFieldWidgets();
        table.setWidget(1, 0, (Widget)dynamicFieldWidget);
        return table;
    }

    private VerticalContainer getDynamicFieldWidgets() {
        VerticalContainer panel = new VerticalContainer();
        panel.setStyleName(QUICK_INFO_TABLE_STYLE);
        for (UiField f : this.fields) {
            if (this.isStaticField(f)) continue;
            HorizontalContainer fieldContainer = new HorizontalContainer();
            LabelWidget fieldNameWidget = new LabelWidget(String.valueOf(f.getDisplayName()) + FIELD_NAME_VALUE_DELIMITER);
            fieldNameWidget.addStyleName(QUICK_INFO_LABEL_STYLE);
            LabelWidget fieldValueWidget = new LabelWidget(f.getValue());
            fieldContainer.add((Widget)fieldNameWidget);
            fieldContainer.add((Widget)fieldValueWidget);
            panel.add((Widget)fieldContainer);
        }
        return panel;
    }

    private VerticalPanel getWidgetForStaticInfo() {
        VerticalContainer staticPanel = new VerticalContainer();
        staticPanel.setStyleName(QUICK_INFO_TABLE_STYLE);
        HorizontalContainer assetIdpanel = new HorizontalContainer();
        assetIdpanel.setSpacing(3);
        ImageWidget statusImage = new ImageWidget();
        TitleClientBundle bundle = new TitleClientBundle();
        String status = this.getStatusFieldValue();
        bundle.updateTitleStatusIcon((Image)statusImage, status, this.getIsOffer());
        assetIdpanel.add((Widget)statusImage);
        staticPanel.add((Widget)assetIdpanel);
        HorizontalContainer piPanel = new HorizontalContainer();
        LabelWidget providerIdLabel = new LabelWidget(String.valueOf(this.displayConstants.providerId()) + FIELD_NAME_VALUE_DELIMITER);
        providerIdLabel.addStyleName(QUICK_INFO_LABEL_STYLE);
        LabelWidget providerValueLabel = new LabelWidget(this.getProviderIdFieldValue());
        piPanel.add((Widget)providerIdLabel);
        piPanel.add((Widget)providerValueLabel);
        staticPanel.add((Widget)piPanel);
        HorizontalContainer tbPanel = new HorizontalContainer();
        LabelWidget titleBriefLabel = new LabelWidget(String.valueOf(this.displayConstants.titleBrief()) + FIELD_NAME_VALUE_DELIMITER);
        titleBriefLabel.addStyleName(QUICK_INFO_LABEL_STYLE);
        LabelWidget titleBriefValueLabel = new LabelWidget(this.getTitleBriefFieldValue());
        tbPanel.add((Widget)titleBriefLabel);
        tbPanel.add((Widget)titleBriefValueLabel);
        staticPanel.add((Widget)tbPanel);
        return staticPanel;
    }

    private String getStatusFieldValue() {
        for (UiField f : this.fields) {
            if (!f.getName().equals(QuickInfoColumnProvider.TITLE_STATUS)) continue;
            return f.getValue();
        }
        return null;
    }

    private String getProviderIdFieldValue() {
        for (UiField f : this.fields) {
            if (!f.getName().equals(QuickInfoColumnProvider.TITLE_PROVIDER_ID_XPATH) || !f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE)) continue;
            return f.getValue();
        }
        return null;
    }

    private String getTitleBriefFieldValue() {
        for (UiField f : this.fields) {
            if (!f.getName().equals(QuickInfoColumnProvider.TITLE_BRIEF_XPATH) || !f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE)) continue;
            return f.getValue();
        }
        return null;
    }

    public void release() {
    }

    private boolean isStaticField(UiField f) {
        if (f.getName().equals(QuickInfoColumnProvider.TITLE_STATUS)) {
            return true;
        }
        if (f.getName().equals(QuickInfoColumnProvider.TITLE_PROVIDER_ID_XPATH) && f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE)) {
            return true;
        }
        return f.getName().equals(QuickInfoColumnProvider.TITLE_BRIEF_XPATH) && f.getParentAssetType().equals(QuickInfoColumnProvider.TITLE_ASSET_TYPE);
    }
}

