/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.assettable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class SearchResultColumnProvider {
    private static String SEARCH_RESULTS_DISPLAY_COL_TABLE = "SearchResultsColumns";
    private static String SERIES_SEARCH_RESULTS_DISPLAY_COL_TABLE = "SeriesSearchResultsColumns";
    private UiCriteriaMode criteriaMode;

    public SearchResultColumnProvider(UiCriteriaMode criteriaMode) {
        this.criteriaMode = criteriaMode;
    }

    public void getDisplayColumns(final AsyncCallback<UiTable> callback) {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(SEARCH_RESULTS_DISPLAY_COL_TABLE, (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                callback.onSuccess((Object)table);
            }
        });
    }

    public List<UiColumn> getSortColumns() {
        return new ArrayList<UiColumn>();
    }

    public List<UiColumn> getQuickInfoFields() {
        return new ArrayList<UiColumn>();
    }

    public void getSearchColumns(final AsyncCallback<SearchColumns> callback) {
        String tablename = this.criteriaMode == UiCriteriaMode.EPISODE ? SEARCH_RESULTS_DISPLAY_COL_TABLE : SERIES_SEARCH_RESULTS_DISPLAY_COL_TABLE;
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(tablename, (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                SearchColumns cols = new SearchColumns();
                cols.setDisplayColumns(table.getColumns());
                cols.setSortColumns(SearchResultColumnProvider.this.getSortCols(table));
                cols.setDefaultInternalSortColumnName(table.getDefaultSortColumnName());
                callback.onSuccess((Object)cols);
            }
        });
    }

    private List<UiColumn> getSortCols(UiTable table) {
        ArrayList<UiColumn> sortCols = new ArrayList<UiColumn>();
        for (UiColumn c : table.getColumns()) {
            if (!c.isSortable()) continue;
            sortCols.add(c);
        }
        return sortCols;
    }

    public class SearchColumns {
        List<UiColumn> displayColumns = new ArrayList<UiColumn>();
        List<UiColumn> sortColumns = new ArrayList<UiColumn>();
        String defaultInternalSortColumnName = "";

        public List<UiColumn> getDisplayColumns() {
            return this.displayColumns;
        }

        public void setDisplayColumns(List<UiColumn> displayColumns) {
            this.displayColumns = displayColumns;
        }

        public List<UiColumn> getSortColumns() {
            return this.sortColumns;
        }

        public void setSortColumns(List<UiColumn> sortColumns) {
            this.sortColumns = sortColumns;
        }

        public String getDefaultInternalSortColumnName() {
            return this.defaultInternalSortColumnName;
        }

        public void setDefaultInternalSortColumnName(String defaultInternalSortColumnName) {
            this.defaultInternalSortColumnName = defaultInternalSortColumnName;
        }
    }
}

